/*
 * Decompiled with CFR 0.152.
 */
package swim.codec;

import swim.codec.Output;
import swim.codec.UtfErrorMode;
import swim.util.Murmur3;

final class UtfFatalErrorMode
extends UtfErrorMode {
    private static int hashSeed;
    private final boolean isNonZero;

    UtfFatalErrorMode(boolean isNonZero) {
        this.isNonZero = isNonZero;
    }

    @Override
    public boolean isFatal() {
        return true;
    }

    @Override
    public boolean isNonZero() {
        return this.isNonZero;
    }

    @Override
    public UtfErrorMode isNonZero(boolean isNonZero) {
        if (isNonZero) {
            return UtfErrorMode.fatalNonZero();
        }
        return UtfErrorMode.fatal();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof UtfFatalErrorMode) {
            UtfFatalErrorMode that = (UtfFatalErrorMode)other;
            return this.isNonZero == that.isNonZero;
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(UtfFatalErrorMode.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)hashSeed, (int)Murmur3.hash((boolean)this.isNonZero)));
    }

    @Override
    public void debug(Output<?> output) {
        output = output.write("UtfErrorMode").write(46).write(this.isNonZero ? "fatalNonZero" : "fatal").write(40).write(41);
    }
}

