/*
 * Decompiled with CFR 0.152.
 */
package swim.codec;

import swim.codec.Base64;
import swim.codec.Diagnostic;
import swim.codec.Input;
import swim.codec.Output;
import swim.codec.Parser;

final class Base64Parser<O>
extends Parser<O> {
    final Output<O> output;
    final Base64 base64;
    final int p;
    final int q;
    final int r;
    final int step;

    Base64Parser(Output<O> output, Base64 base64, int p, int q, int r, int step) {
        this.output = output;
        this.base64 = base64;
        this.p = p;
        this.q = q;
        this.r = r;
        this.step = step;
    }

    Base64Parser(Output<O> output, Base64 base64) {
        this(output, base64, 0, 0, 0, 1);
    }

    /*
     * Enabled aggressive block sorting
     */
    static <O> Parser<O> parse(Input input, Output<O> output, Base64 base64, int p, int q, int r, int step) {
        int c = 0;
        while (!input.isError() && !input.isEmpty()) {
            block26: {
                if (step == 1) {
                    if (input.isCont()) {
                        c = input.head();
                        if (!base64.isDigit(c)) {
                            return Base64Parser.done(output.bind());
                        }
                        input = input.step();
                        p = c;
                        step = 2;
                    } else if (input.isDone()) {
                        return Base64Parser.done(output.bind());
                    }
                }
                if (step == 2) {
                    if (input.isCont()) {
                        c = input.head();
                        if (!base64.isDigit(c)) {
                            return Base64Parser.error(Diagnostic.expected("base64 digit", input));
                        }
                        input = input.step();
                        q = c;
                        step = 3;
                    } else if (input.isDone()) {
                        return Base64Parser.error(Diagnostic.expected("base64 digit", input));
                    }
                }
                if (step == 3) {
                    if (input.isCont()) {
                        c = input.head();
                        if (base64.isDigit(c) || c == 61) {
                            input = input.step();
                            r = c;
                            step = c != 61 ? 4 : 5;
                            break block26;
                        } else {
                            if (!base64.isPadded()) {
                                base64.writeQuantum(p, q, 61, 61, output);
                                return Base64Parser.done(output.bind());
                            }
                            return Base64Parser.error(Diagnostic.expected("base64 digit", input));
                        }
                    }
                    if (input.isDone()) {
                        if (!base64.isPadded()) {
                            base64.writeQuantum(p, q, 61, 61, output);
                            return Base64Parser.done(output.bind());
                        }
                        return Base64Parser.error(Diagnostic.expected("base64 digit", input));
                    }
                }
            }
            if (step == 4) {
                if (input.isCont()) {
                    c = input.head();
                    if (base64.isDigit(c) || c == 61) {
                        input = input.step();
                        base64.writeQuantum(p, q, r, c, output);
                        r = 0;
                        q = 0;
                        p = 0;
                        if (c == 61) return Base64Parser.done(output.bind());
                        step = 1;
                        continue;
                    }
                    if (!base64.isPadded()) {
                        base64.writeQuantum(p, q, r, 61, output);
                        return Base64Parser.done(output.bind());
                    }
                    return Base64Parser.error(Diagnostic.expected("base64 digit", input));
                }
                if (!input.isDone()) continue;
                if (!base64.isPadded()) {
                    base64.writeQuantum(p, q, r, 61, output);
                    return Base64Parser.done(output.bind());
                }
                return Base64Parser.error(Diagnostic.expected("base64 digit", input));
            }
            if (step != 5) continue;
            if (input.isCont()) {
                c = input.head();
                if (c == 61) {
                    input = input.step();
                    base64.writeQuantum(p, q, r, c, output);
                    return Base64Parser.done(output.bind());
                }
                return Base64Parser.error(Diagnostic.expected(61, input));
            }
            if (!input.isDone()) continue;
            return Base64Parser.error(Diagnostic.expected(61, input));
        }
        if (input.isError()) {
            return Base64Parser.error(input.trap());
        }
        return new Base64Parser<O>(output, base64, p, q, r, step);
    }

    static <O> Parser<O> parse(Input input, Output<O> output, Base64 base64) {
        return Base64Parser.parse(input, output, base64, 0, 0, 0, 1);
    }

    @Override
    public Parser<O> feed(Input input) {
        return Base64Parser.parse(input, this.output.clone(), this.base64, this.p, this.q, this.r, this.step);
    }
}

