/*
 * Decompiled with CFR 0.152.
 */
package swim.codec;

import swim.codec.EncoderAndThen;
import swim.codec.EncoderDone;
import swim.codec.EncoderError;
import swim.codec.OutputBuffer;

public abstract class Encoder<I, O> {
    private static Encoder<Object, Object> done;

    public static <I, O> Encoder<I, O> done() {
        if (done == null) {
            done = new EncoderDone<Object, Object>(null);
        }
        return done;
    }

    public static <I, O> Encoder<I, O> done(O output) {
        if (output == null) {
            return Encoder.done();
        }
        return new EncoderDone(output);
    }

    public static <I, O> Encoder<I, O> error(Throwable error) {
        return new EncoderError(error);
    }

    public boolean isCont() {
        return true;
    }

    public boolean isDone() {
        return false;
    }

    public boolean isError() {
        return false;
    }

    public Encoder<I, O> feed(I input) {
        throw new IllegalStateException();
    }

    public abstract Encoder<I, O> pull(OutputBuffer<?> var1);

    public Encoder<I, O> fork(Object condition) {
        return this;
    }

    public O bind() {
        return null;
    }

    public Throwable trap() {
        throw new IllegalStateException();
    }

    public <I2> Encoder<I2, O> asDone() {
        throw new IllegalStateException();
    }

    public <I2, O2> Encoder<I2, O2> asError() {
        throw new IllegalStateException();
    }

    public <O2> Encoder<I, O2> andThen(Encoder<I, O2> that) {
        return new EncoderAndThen<I, O2>(this, that);
    }
}

