/*
 * Decompiled with CFR 0.152.
 */
package swim.codec;

import swim.codec.Base16;
import swim.codec.Diagnostic;
import swim.codec.Input;
import swim.codec.Parser;

final class HexadecimalParser
extends Parser<Number> {
    final long value;
    final int size;

    HexadecimalParser(long value, int size) {
        this.value = value;
        this.size = size;
    }

    static Parser<Number> parse(Input input, long value, int size) {
        int c = 0;
        while (input.isCont() && Base16.isDigit(c = input.head())) {
            input = input.step();
            value = value << 4 | (long)Base16.decodeDigit(c);
            ++size;
        }
        if (!input.isEmpty()) {
            if (size > 0) {
                if (size <= 8) {
                    return HexadecimalParser.done((int)value);
                }
                return HexadecimalParser.done(value);
            }
            return HexadecimalParser.error(Diagnostic.expected("hex digit", input));
        }
        if (input.isError()) {
            return HexadecimalParser.error(input.trap());
        }
        return new HexadecimalParser(value, size);
    }

    static Parser<Number> parse(Input input) {
        return HexadecimalParser.parse(input, 0L, 0);
    }

    @Override
    public Parser<Number> feed(Input input) {
        return HexadecimalParser.parse(input, this.value, this.size);
    }
}

