/*
 * Decompiled with CFR 0.152.
 */
package swim.codec;

import swim.codec.Input;
import swim.codec.Parser;

final class StringParser
extends Parser<String> {
    final StringBuilder builder;

    StringParser(StringBuilder builder) {
        this.builder = builder;
    }

    StringParser() {
        this(null);
    }

    static Parser<String> parse(Input input, StringBuilder builder) {
        if (builder == null) {
            builder = new StringBuilder();
        }
        while (input.isCont()) {
            builder.appendCodePoint(input.head());
            input = input.step();
        }
        if (input.isDone()) {
            return StringParser.done(builder.toString());
        }
        if (input.isError()) {
            return StringParser.error(input.trap());
        }
        return new StringParser(builder);
    }

    static Parser<String> parse(Input input) {
        return StringParser.parse(input, null);
    }

    @Override
    public Parser<String> feed(Input input) {
        return StringParser.parse(input, this.builder);
    }
}

