/*
 * Decompiled with CFR 0.152.
 */
package swim.codec;

import swim.codec.Input;
import swim.codec.InputBufferDone;
import swim.codec.InputBufferEmpty;
import swim.codec.InputBufferError;
import swim.codec.InputSettings;
import swim.codec.Mark;

public abstract class InputBuffer
extends Input {
    private static InputBuffer empty;
    private static InputBuffer done;

    public static InputBuffer empty() {
        if (empty == null) {
            empty = new InputBufferEmpty(null, Mark.zero(), InputSettings.standard());
        }
        return empty;
    }

    public static InputBuffer empty(InputSettings settings) {
        if (settings == InputSettings.standard()) {
            return InputBuffer.empty();
        }
        return new InputBufferEmpty(null, Mark.zero(), settings);
    }

    public static InputBuffer empty(Object id, Mark mark) {
        if (id == null && (mark == null || mark == Mark.zero())) {
            return InputBuffer.empty();
        }
        return new InputBufferEmpty(id, mark, InputSettings.standard());
    }

    public static InputBuffer empty(Object id, Mark mark, InputSettings settings) {
        if (id == null && (mark == null || mark == Mark.zero()) && settings == InputSettings.standard()) {
            return InputBuffer.empty();
        }
        return new InputBufferEmpty(id, mark, settings);
    }

    public static InputBuffer done() {
        if (done == null) {
            done = new InputBufferDone(null, Mark.zero(), InputSettings.standard());
        }
        return done;
    }

    public static InputBuffer done(InputSettings settings) {
        if (settings == InputSettings.standard()) {
            return InputBuffer.done();
        }
        return new InputBufferDone(null, Mark.zero(), settings);
    }

    public static InputBuffer done(Object id, Mark mark) {
        if (id == null && (mark == null || mark == Mark.zero())) {
            return InputBuffer.done();
        }
        return new InputBufferDone(id, mark, InputSettings.standard());
    }

    public static InputBuffer done(Object id, Mark mark, InputSettings settings) {
        if (id == null && (mark == null || mark == Mark.zero()) && settings == InputSettings.standard()) {
            return InputBuffer.done();
        }
        return new InputBufferDone(id, mark, settings);
    }

    public static InputBuffer error(Throwable error) {
        return new InputBufferError(error, null, Mark.zero(), InputSettings.standard());
    }

    public static InputBuffer error(Throwable error, InputSettings settings) {
        return new InputBufferError(error, null, Mark.zero(), settings);
    }

    public static InputBuffer error(Throwable error, Object id, Mark mark) {
        return new InputBufferError(error, id, mark, InputSettings.standard());
    }

    public static InputBuffer error(Throwable error, Object id, Mark mark, InputSettings settings) {
        return new InputBufferError(error, id, mark, settings);
    }

    @Override
    public abstract InputBuffer isPart(boolean var1);

    public abstract int index();

    public abstract InputBuffer index(int var1);

    public abstract int limit();

    public abstract InputBuffer limit(int var1);

    public abstract int capacity();

    public abstract int remaining();

    public abstract byte[] array();

    public abstract int arrayOffset();

    public abstract boolean has(int var1);

    public abstract int get(int var1);

    public abstract void set(int var1, int var2);

    @Override
    public abstract InputBuffer step();

    public abstract InputBuffer step(int var1);

    @Override
    public abstract InputBuffer seek(Mark var1);

    @Override
    public InputBuffer fork(Object condition) {
        return this;
    }

    @Override
    public abstract InputBuffer id(Object var1);

    @Override
    public abstract InputBuffer mark(Mark var1);

    @Override
    public abstract InputBuffer settings(InputSettings var1);

    @Override
    public abstract InputBuffer clone();
}

