/*
 * Decompiled with CFR 0.152.
 */
package swim.codec;

import java.util.Objects;
import swim.codec.Format;
import swim.codec.Mark;
import swim.codec.Output;
import swim.codec.Tag;
import swim.util.Murmur3;

public final class Span
extends Tag {
    private static int hashSeed;
    final Mark start;
    final Mark end;

    Span(Mark start, Mark end) {
        this.start = start;
        this.end = end;
    }

    public static Span from(Mark start, Mark end) {
        start = Objects.requireNonNull(start);
        end = Objects.requireNonNull(end);
        if (start.offset > end.offset) {
            Mark tmp = start;
            start = end;
            end = tmp;
        }
        return new Span(start, end);
    }

    @Override
    public Mark start() {
        return this.start;
    }

    @Override
    public Mark end() {
        return this.end;
    }

    @Override
    public Tag union(Tag other) {
        if (other instanceof Mark) {
            Mark that = (Mark)other;
            Mark start = this.start.min(that);
            Mark end = this.end.max(that);
            if (start == this.start && end == this.end) {
                return this;
            }
            return Span.from(start, end);
        }
        if (other instanceof Span) {
            Span that = (Span)other;
            Mark start = this.start.min(that.start);
            Mark end = this.end.max(that.end);
            if (start == this.start && end == this.end) {
                return this;
            }
            return Span.from(start, end);
        }
        throw new UnsupportedOperationException(other.toString());
    }

    @Override
    public Span shift(Mark mark) {
        Mark start = this.start.shift(mark);
        Mark end = this.end.shift(mark);
        if (start == this.start && end == this.end) {
            return this;
        }
        return Span.from(start, end);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof Span) {
            Span that = (Span)other;
            return this.start.equals(that.start) && this.end.equals(that.end);
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(Span.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)Murmur3.mix((int)hashSeed, (int)this.start.hashCode()), (int)this.end.hashCode()));
    }

    @Override
    public void display(Output<?> output) {
        if (this.start.note != null) {
            output = output.write(this.start.note).write(": ");
        }
        Format.displayInt(this.start.line, output);
        output = output.write(58);
        Format.displayInt(this.start.column, output);
        output = output.write(45);
        Format.displayInt(this.end.line, output);
        output = output.write(58);
        Format.displayInt(this.end.column, output);
        if (this.end.note != null) {
            output = output.write(": ").write(this.end.note);
        }
    }

    @Override
    public void debug(Output<?> output) {
        output = output.write("Span").write(46).write("from").write(40);
        this.start.debug(output);
        output = output.write(", ");
        this.end.debug(output);
        output = output.write(41);
    }

    public String toString() {
        return Format.display(this);
    }
}

