/*
 * Decompiled with CFR 0.152.
 */
package swim.codec;

import swim.codec.ByteParser;
import swim.codec.Input;
import swim.codec.LineParser;
import swim.codec.NullParser;
import swim.codec.Output;
import swim.codec.OutputSettings;
import swim.codec.Parser;
import swim.codec.StringInput;
import swim.codec.StringOutput;
import swim.codec.StringParser;
import swim.codec.StringWriter;
import swim.codec.Writer;

public final class Unicode {
    private Unicode() {
    }

    public static Input stringInput(String string) {
        return new StringInput(string);
    }

    public static Output<String> stringOutput(StringBuilder builder, OutputSettings settings) {
        return new StringOutput(builder, settings);
    }

    public static Output<String> stringOutput(StringBuilder builder) {
        return new StringOutput(builder, OutputSettings.standard());
    }

    public static Output<String> stringOutput(String string, OutputSettings settings) {
        return new StringOutput(new StringBuilder(string), settings);
    }

    public static Output<String> stringOutput(String string) {
        return new StringOutput(new StringBuilder(string), OutputSettings.standard());
    }

    public static Output<String> stringOutput(int initialCapacity, OutputSettings settings) {
        return new StringOutput(new StringBuilder(initialCapacity), settings);
    }

    public static Output<String> stringOutput(int initialCapacity) {
        return new StringOutput(new StringBuilder(initialCapacity), OutputSettings.standard());
    }

    public static Output<String> stringOutput(OutputSettings settings) {
        return new StringOutput(new StringBuilder(), settings);
    }

    public static Output<String> stringOutput() {
        return new StringOutput(new StringBuilder(), OutputSettings.standard());
    }

    public static Parser<String> stringParser(StringBuilder builder) {
        return new StringParser(builder);
    }

    public static Parser<String> stringParser() {
        return new StringParser();
    }

    public static Parser<String> parseString(Input input, StringBuilder builder) {
        return StringParser.parse(input, builder);
    }

    public static Parser<String> parseString(Input input) {
        return StringParser.parse(input);
    }

    public static <O> Parser<O> outputParser(Output<O> output) {
        return new ByteParser<O>(output);
    }

    public static <O> Parser<O> parseOutput(Output<O> output, Input input) {
        return ByteParser.parse(input, output);
    }

    public static <O> Parser<O> nullParser() {
        return new NullParser();
    }

    public static <O> Parser<O> parseNull(Input input) {
        return NullParser.parse(input);
    }

    public static <I> Writer<I, Object> stringWriter() {
        return new StringWriter();
    }

    public static <I, O> Writer<I, O> stringWriter(O input) {
        return new StringWriter(input, input);
    }

    public static <I> Writer<I, Object> writeString(Object input, Output<?> output) {
        return StringWriter.write(output, null, input);
    }

    public static Parser<String> lineParser() {
        return new LineParser();
    }

    public static Parser<String> parseLine(Input input, StringBuilder output) {
        return LineParser.parse(input, output);
    }

    public static Parser<String> parseLine(Input input) {
        return LineParser.parse(input, new StringBuilder());
    }
}

