/*
 * Decompiled with CFR 0.152.
 */
package swim.codec;

import java.io.IOException;
import java.io.InputStream;
import swim.codec.Binary;
import swim.codec.Decoder;
import swim.codec.Input;
import swim.codec.InputBuffer;
import swim.codec.InputParser;
import swim.codec.Output;
import swim.codec.OutputParser;
import swim.codec.OutputWriter;
import swim.codec.Parser;
import swim.codec.Unicode;
import swim.codec.Utf8DecodedInput;
import swim.codec.Utf8DecodedOutput;
import swim.codec.Utf8EncodedOutput;
import swim.codec.UtfErrorMode;
import swim.codec.Writer;

public final class Utf8 {
    private Utf8() {
    }

    public static int sizeOf(int c, UtfErrorMode errorMode) {
        if (c == 0 && errorMode.isNonZero()) {
            return 2;
        }
        if (c >= 0 && c <= 127) {
            return 1;
        }
        if (c >= 128 && c <= 2047) {
            return 2;
        }
        if (c >= 2048 && c <= 65535 || c >= 57344 && c <= 65535) {
            return 3;
        }
        if (c >= 65536 && c <= 0x10FFFF) {
            return 4;
        }
        if (errorMode.isReplacement()) {
            return Utf8.sizeOf(errorMode.replacementChar());
        }
        return 0;
    }

    public static int sizeOf(int c) {
        if (c >= 0 && c <= 127) {
            return 1;
        }
        if (c >= 128 && c <= 2047) {
            return 2;
        }
        if (c >= 2048 && c <= 65535 || c >= 57344 && c <= 65535) {
            return 3;
        }
        if (c >= 65536 && c <= 0x10FFFF) {
            return 4;
        }
        return 3;
    }

    public static int sizeOf(String string, UtfErrorMode errorMode) {
        int size = 0;
        int i = 0;
        int n = string.length();
        while (i < n) {
            size += Utf8.sizeOf(string.codePointAt(i), errorMode);
            i = string.offsetByCodePoints(i, 1);
        }
        return size;
    }

    public static int sizeOf(String string) {
        int size = 0;
        int i = 0;
        int n = string.length();
        while (i < n) {
            size += Utf8.sizeOf(string.codePointAt(i));
            i = string.offsetByCodePoints(i, 1);
        }
        return size;
    }

    public static Input decodedInput(Input input, UtfErrorMode errorMode) {
        return new Utf8DecodedInput(input, errorMode);
    }

    public static Input decodedInput(Input input) {
        return new Utf8DecodedInput(input, UtfErrorMode.fatal());
    }

    public static <T> Output<T> decodedOutput(Output<T> output, UtfErrorMode errorMode) {
        return new Utf8DecodedOutput<T>(output, errorMode);
    }

    public static <T> Output<T> decodedOutput(Output<T> output) {
        return new Utf8DecodedOutput<T>(output, UtfErrorMode.fatal());
    }

    public static Output<String> decodedString() {
        return Utf8.decodedOutput(Unicode.stringOutput());
    }

    public static <T> Output<T> encodedOutput(Output<T> output, UtfErrorMode errorMode) {
        return new Utf8EncodedOutput<T>(output, errorMode);
    }

    public static <T> Output<T> encodedOutput(Output<T> output) {
        return new Utf8EncodedOutput<T>(output, UtfErrorMode.fatal());
    }

    public static Parser<String> stringParser(StringBuilder builder, UtfErrorMode errorMode) {
        return new InputParser<String>(Utf8.decodedInput(Input.empty(), errorMode), Unicode.stringParser(builder));
    }

    public static Parser<String> stringParser(StringBuilder builder) {
        return new InputParser<String>(Utf8.decodedInput(Input.empty()), Unicode.stringParser(builder));
    }

    public static Parser<String> stringParser(UtfErrorMode errorMode) {
        return new InputParser<String>(Utf8.decodedInput(Input.empty(), errorMode), Unicode.stringParser());
    }

    public static Parser<String> stringParser() {
        return new InputParser<String>(Utf8.decodedInput(Input.empty()), Unicode.stringParser());
    }

    public static Parser<String> parseString(Input input, StringBuilder builder, UtfErrorMode errorMode) {
        return InputParser.parse(Utf8.decodedInput(input, errorMode), Unicode.stringParser(builder));
    }

    public static Parser<String> parseString(Input input, StringBuilder builder) {
        return InputParser.parse(Utf8.decodedInput(input), Unicode.stringParser(builder));
    }

    public static Parser<String> parseString(Input input, UtfErrorMode errorMode) {
        return InputParser.parse(Utf8.decodedInput(input, errorMode), Unicode.stringParser());
    }

    public static Parser<String> parseString(Input input) {
        return InputParser.parse(Utf8.decodedInput(input), Unicode.stringParser());
    }

    public static <I, O> Writer<I, O> stringWriter(O input, UtfErrorMode errorMode) {
        Writer writer = Unicode.stringWriter(input);
        return new OutputWriter(Utf8.encodedOutput(Output.full(), errorMode), writer);
    }

    public static <I, O> Writer<I, O> stringWriter(O input) {
        Writer writer = Unicode.stringWriter(input);
        return new OutputWriter(Utf8.encodedOutput(Output.full()), writer);
    }

    public static <O> Writer<?, O> writeString(O input, Output<?> output, UtfErrorMode errorMode) {
        return OutputWriter.write(Utf8.encodedOutput(output, errorMode), Unicode.stringWriter(input));
    }

    public static <O> Writer<?, O> writeString(O input, Output<?> output) {
        return OutputWriter.write(Utf8.encodedOutput(output), Unicode.stringWriter(input));
    }

    public static <O> Decoder<O> outputDecoder(Output<O> output, UtfErrorMode errorMode) {
        return new OutputParser<O>(Utf8.decodedInput(Input.empty(), errorMode), output);
    }

    public static <O> Decoder<O> outputDecoder(Output<O> output) {
        return new OutputParser<O>(Utf8.decodedInput(Input.empty()), output);
    }

    public static <O> Decoder<O> decodeOutput(Output<O> output, InputBuffer input, UtfErrorMode errorMode) {
        return OutputParser.parse(Utf8.decodedInput(input, errorMode), output);
    }

    public static <O> Decoder<O> decodeOutput(Output<O> output, Input input) {
        return OutputParser.parse(Utf8.decodedInput(input), output);
    }

    public static <O> Parser<O> decodedParser(Parser<O> parser, UtfErrorMode errorMode) {
        return new InputParser<O>(Utf8.decodedInput(Input.empty(), errorMode), parser);
    }

    public static <O> Parser<O> decodedParser(Parser<O> parser) {
        return new InputParser<O>(Utf8.decodedInput(Input.empty()), parser);
    }

    public static <O> Parser<O> parseDecoded(Parser<O> parser, Input input, UtfErrorMode errorMode) {
        return InputParser.parse(Utf8.decodedInput(input, errorMode), parser);
    }

    public static <O> Parser<O> parseDecoded(Parser<O> parser, Input input) {
        return InputParser.parse(Utf8.decodedInput(input), parser);
    }

    public static <I, O> Writer<I, O> encodedWriter(Writer<I, O> writer, UtfErrorMode errorMode) {
        return new OutputWriter<I, O>(Utf8.encodedOutput(Output.full(), errorMode), writer);
    }

    public static <I, O> Writer<I, O> encodedWriter(Writer<I, O> writer) {
        return new OutputWriter<I, O>(Utf8.encodedOutput(Output.full()), writer);
    }

    public static <I, O> Writer<I, O> writeEncoded(Writer<I, O> writer, Output<?> output, UtfErrorMode errorMode) {
        return OutputWriter.write(Utf8.encodedOutput(output, errorMode), writer);
    }

    public static <I, O> Writer<I, O> writeEncoded(Writer<I, O> writer, Output<?> output) {
        return OutputWriter.write(Utf8.encodedOutput(output), writer);
    }

    public static <O> Decoder<O> decode(Parser<O> parser, InputStream input) throws IOException {
        return Binary.decode(Utf8.decodedParser(parser), input);
    }

    public static <O> O read(Parser<O> parser, InputStream input) throws IOException {
        return Binary.read(Utf8.decodedParser(parser), input);
    }
}

