/*
 * Decompiled with CFR 0.152.
 */
package swim.codec;

import swim.codec.Format;
import swim.codec.Output;
import swim.codec.UtfErrorMode;
import swim.util.Murmur3;

final class UtfReplacementErrorMode
extends UtfErrorMode {
    private static int hashSeed;
    private final int replacementChar;
    private final boolean isNonZero;

    UtfReplacementErrorMode(int replacementChar, boolean isNonZero) {
        this.replacementChar = replacementChar;
        this.isNonZero = isNonZero;
    }

    @Override
    public boolean isReplacement() {
        return true;
    }

    @Override
    public int replacementChar() {
        return this.replacementChar;
    }

    @Override
    public boolean isNonZero() {
        return this.isNonZero;
    }

    @Override
    public UtfErrorMode isNonZero(boolean isNonZero) {
        if (this.replacementChar == 65533) {
            if (isNonZero) {
                return UtfErrorMode.replacementNonZero();
            }
            return UtfErrorMode.replacement();
        }
        return new UtfReplacementErrorMode(this.replacementChar, isNonZero);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof UtfReplacementErrorMode) {
            UtfReplacementErrorMode that = (UtfReplacementErrorMode)other;
            return this.replacementChar == that.replacementChar && this.isNonZero == that.isNonZero;
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(UtfReplacementErrorMode.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)Murmur3.mix((int)hashSeed, (int)this.replacementChar), (int)Murmur3.hash((boolean)this.isNonZero)));
    }

    @Override
    public void debug(Output<?> output) {
        output = output.write("UtfErrorMode").write(46).write(this.isNonZero ? "replacementNonZero" : "replacement").write(40);
        if (this.replacementChar != 65533) {
            Format.debugChar(this.replacementChar, output);
        }
        output = output.write(41);
    }
}

