/*
 * Decompiled with CFR 0.152.
 */
package swim.codec;

import swim.codec.Base10;
import swim.codec.Output;
import swim.codec.StringWriter;
import swim.codec.Writer;
import swim.codec.WriterException;

final class Base10IntegerWriter
extends Writer<Object, Object> {
    final Object value;
    final long input;
    final int index;
    final int step;

    Base10IntegerWriter(Object value, long input, int index, int step) {
        this.value = value;
        this.input = input;
        this.index = index;
        this.step = step;
    }

    Base10IntegerWriter(Object value, long input) {
        this(value, input, 0, 1);
    }

    Base10IntegerWriter() {
        this(null, 0L, 0, 0);
    }

    @Override
    public Writer<Object, Object> feed(Object input) {
        if (input instanceof Integer) {
            return new Base10IntegerWriter(input, ((Integer)input).longValue());
        }
        if (input instanceof Long) {
            return new Base10IntegerWriter(input, (Long)input);
        }
        return new StringWriter(input, input);
    }

    @Override
    public Writer<Object, Object> pull(Output<?> output) {
        return Base10IntegerWriter.write(output, this.value, this.input, this.index, this.step);
    }

    static Writer<Object, Object> write(Output<?> output, Object value, long input, int index, int step) {
        if (step == 0) {
            return Writer.done();
        }
        if (step == 1) {
            if (input < 0L) {
                if (output.isCont()) {
                    output = output.write(45);
                    step = 2;
                }
            } else {
                step = 2;
            }
        }
        if (step == 2) {
            if (input > -10L && input < 10L) {
                if (output.isCont()) {
                    output = output.write(Base10.encodeDigit(Math.abs((int)input)));
                    return Writer.done(value);
                }
            } else {
                int i = 18;
                int[] digits = new int[19];
                long x = input;
                while (x != 0L) {
                    digits[i] = Math.abs((int)(x % 10L));
                    x /= 10L;
                    --i;
                }
                i += 1 + index;
                while (i < 19 && output.isCont()) {
                    output = output.write(Base10.encodeDigit(digits[i]));
                    ++index;
                    ++i;
                }
                if (i == 19) {
                    return Writer.done(value);
                }
            }
        }
        if (output.isDone()) {
            return Writer.error(new WriterException("truncated"));
        }
        if (output.isError()) {
            return Writer.error(output.trap());
        }
        return new Base10IntegerWriter(value, input, index, step);
    }

    static Writer<Object, Object> write(Output<?> output, Object value, long input) {
        return Base10IntegerWriter.write(output, value, input, 0, 1);
    }
}

