/*
 * Decompiled with CFR 0.152.
 */
package swim.codec;

import swim.codec.Base64;
import swim.codec.Diagnostic;
import swim.codec.Input;
import swim.codec.Output;
import swim.codec.Parser;

final class Base64Parser<O>
extends Parser<O> {
    final Base64 base64;
    final Output<O> output;
    final int p;
    final int q;
    final int r;
    final int step;

    Base64Parser(Base64 base64, Output<O> output, int p, int q, int r, int step) {
        this.base64 = base64;
        this.output = output;
        this.p = p;
        this.q = q;
        this.r = r;
        this.step = step;
    }

    Base64Parser(Base64 base64, Output<O> output) {
        this(base64, output, 0, 0, 0, 1);
    }

    @Override
    public Parser<O> feed(Input input) {
        return Base64Parser.parse(input, this.base64, this.output.clone(), this.p, this.q, this.r, this.step);
    }

    /*
     * Enabled aggressive block sorting
     */
    static <O> Parser<O> parse(Input input, Base64 base64, Output<O> output, int p, int q, int r, int step) {
        int c = 0;
        while (!input.isError() && !input.isEmpty()) {
            block26: {
                if (step == 1) {
                    if (input.isCont()) {
                        c = input.head();
                        if (!base64.isDigit(c)) {
                            return Parser.done(output.bind());
                        }
                        input = input.step();
                        p = c;
                        step = 2;
                    } else if (input.isDone()) {
                        return Parser.done(output.bind());
                    }
                }
                if (step == 2) {
                    if (input.isCont()) {
                        c = input.head();
                        if (!base64.isDigit(c)) {
                            return Parser.error(Diagnostic.expected("base64 digit", input));
                        }
                        input = input.step();
                        q = c;
                        step = 3;
                    } else if (input.isDone()) {
                        return Parser.error(Diagnostic.expected("base64 digit", input));
                    }
                }
                if (step == 3) {
                    if (input.isCont()) {
                        c = input.head();
                        if (base64.isDigit(c) || c == 61) {
                            input = input.step();
                            r = c;
                            step = c != 61 ? 4 : 5;
                            break block26;
                        } else {
                            if (!base64.isPadded()) {
                                output = base64.writeQuantum(output, p, q, 61, 61);
                                return Parser.done(output.bind());
                            }
                            return Parser.error(Diagnostic.expected("base64 digit", input));
                        }
                    }
                    if (input.isDone()) {
                        if (!base64.isPadded()) {
                            output = base64.writeQuantum(output, p, q, 61, 61);
                            return Parser.done(output.bind());
                        }
                        return Parser.error(Diagnostic.expected("base64 digit", input));
                    }
                }
            }
            if (step == 4) {
                if (input.isCont()) {
                    c = input.head();
                    if (base64.isDigit(c) || c == 61) {
                        input = input.step();
                        output = base64.writeQuantum(output, p, q, r, c);
                        r = 0;
                        q = 0;
                        p = 0;
                        if (c == 61) return Parser.done(output.bind());
                        step = 1;
                        continue;
                    }
                    if (!base64.isPadded()) {
                        output = base64.writeQuantum(output, p, q, r, 61);
                        return Parser.done(output.bind());
                    }
                    return Parser.error(Diagnostic.expected("base64 digit", input));
                }
                if (!input.isDone()) continue;
                if (!base64.isPadded()) {
                    output = base64.writeQuantum(output, p, q, r, 61);
                    return Parser.done(output.bind());
                }
                return Parser.error(Diagnostic.expected("base64 digit", input));
            }
            if (step != 5) continue;
            if (input.isCont()) {
                c = input.head();
                if (c == 61) {
                    input = input.step();
                    output = base64.writeQuantum(output, p, q, r, c);
                    return Parser.done(output.bind());
                }
                return Parser.error(Diagnostic.expected(61, input));
            }
            if (!input.isDone()) continue;
            return Parser.error(Diagnostic.expected(61, input));
        }
        if (input.isError()) {
            return Parser.error(input.trap());
        }
        return new Base64Parser<O>(base64, output, p, q, r, step);
    }

    static <O> Parser<O> parse(Input input, Base64 base64, Output<O> output) {
        return Base64Parser.parse(input, base64, output, 0, 0, 0, 1);
    }
}

