/*
 * Decompiled with CFR 0.152.
 */
package swim.codec;

import java.nio.ByteBuffer;
import swim.codec.Base64;
import swim.codec.Output;
import swim.codec.Writer;
import swim.codec.WriterException;

final class Base64Writer
extends Writer<Object, Object> {
    final Base64 base64;
    final Object value;
    final ByteBuffer input;
    final int index;
    final int limit;
    final int step;

    Base64Writer(Base64 base64, Object value, ByteBuffer input, int index, int limit, int step) {
        this.base64 = base64;
        this.value = value;
        this.input = input;
        this.index = index;
        this.limit = limit;
        this.step = step;
    }

    Base64Writer(Base64 base64, Object value, ByteBuffer input) {
        this(base64, value, input, input.position(), input.limit(), 1);
    }

    Base64Writer(Base64 base64, Object value, byte[] input) {
        this(base64, value, ByteBuffer.wrap(input));
    }

    Base64Writer(Base64 base64) {
        this(base64, null, null, 0, 0, 0);
    }

    @Override
    public Writer<Object, Object> feed(Object value) {
        if (value instanceof ByteBuffer) {
            return new Base64Writer(this.base64, null, (ByteBuffer)value);
        }
        if (value instanceof byte[]) {
            return new Base64Writer(this.base64, null, (byte[])value);
        }
        throw new IllegalArgumentException(value.toString());
    }

    @Override
    public Writer<Object, Object> pull(Output<?> output) {
        return Base64Writer.write(output, this.base64, this.value, this.input, this.index, this.limit, this.step);
    }

    static Writer<Object, Object> write(Output<?> output, Base64 base64, Object value, ByteBuffer input, int index, int limit, int step) {
        int y;
        int x;
        while (index + 2 < limit && output.isCont()) {
            x = input.get(index) & 0xFF;
            y = input.get(index + 1) & 0xFF;
            int z = input.get(index + 2) & 0xFF;
            if (step == 1 && output.isCont()) {
                output = output.write(base64.encodeDigit(x >>> 2));
                step = 2;
            }
            if (step == 2 && output.isCont()) {
                output = output.write(base64.encodeDigit((x << 4 | y >>> 4) & 0x3F));
                step = 3;
            }
            if (step == 3 && output.isCont()) {
                output = output.write(base64.encodeDigit((y << 2 | z >>> 6) & 0x3F));
                step = 4;
            }
            if (step != 4 || !output.isCont()) continue;
            output = output.write(base64.encodeDigit(z & 0x3F));
            index += 3;
            step = 1;
        }
        if (index + 1 < limit && output.isCont()) {
            x = input.get(index) & 0xFF;
            y = input.get(index + 1) & 0xFF;
            if (step == 1 && output.isCont()) {
                output = output.write(base64.encodeDigit(x >>> 2));
                step = 2;
            }
            if (step == 2 && output.isCont()) {
                output = output.write(base64.encodeDigit((x << 4 | y >>> 4) & 0x3F));
                step = 3;
            }
            if (step == 3 && output.isCont()) {
                output = output.write(base64.encodeDigit(y << 2 & 0x3F));
                step = 4;
            }
            if (step == 4) {
                if (!base64.isPadded()) {
                    index += 2;
                } else if (output.isCont()) {
                    output = output.write(61);
                    index += 2;
                }
            }
        } else if (index < limit && output.isCont()) {
            x = input.get(index) & 0xFF;
            if (step == 1 && output.isCont()) {
                output = output.write(base64.encodeDigit(x >>> 2));
                step = 2;
            }
            if (step == 2 && output.isCont()) {
                output = output.write(base64.encodeDigit(x << 4 & 0x3F));
                step = 3;
            }
            if (step == 3) {
                if (!base64.isPadded()) {
                    ++index;
                } else if (output.isCont()) {
                    output = output.write(61);
                    step = 4;
                }
            }
            if (step == 4 && output.isCont()) {
                output = output.write(61);
                ++index;
            }
        }
        if (index == limit) {
            return Writer.done(value);
        }
        if (output.isDone()) {
            return Writer.error(new WriterException("truncated"));
        }
        if (output.isError()) {
            return Writer.error(output.trap());
        }
        return new Base64Writer(base64, value, input, index, limit, step);
    }

    static Writer<?, ?> write(Output<?> output, Base64 base64, Object value, ByteBuffer input) {
        return Base64Writer.write(output, base64, value, input, input.position(), input.limit(), 1);
    }

    static Writer<?, ?> write(Output<?> output, Base64 base64, Object value, byte[] input) {
        return Base64Writer.write(output, base64, value, ByteBuffer.wrap(input));
    }
}

