/*
 * Decompiled with CFR 0.152.
 */
package swim.codec;

import java.util.AbstractMap;
import java.util.Map;
import java.util.Objects;
import swim.codec.Base10;
import swim.codec.Display;
import swim.codec.Format;
import swim.codec.Input;
import swim.codec.Mark;
import swim.codec.Output;
import swim.codec.OutputSettings;
import swim.codec.OutputStyle;
import swim.codec.Tag;
import swim.codec.Unicode;
import swim.util.Severity;

public final class Diagnostic
implements Display {
    final Input input;
    final Tag tag;
    final Severity severity;
    final String message;
    final String note;
    final Diagnostic cause;

    Diagnostic(Input input, Tag tag, Severity severity, String message, String note, Diagnostic cause) {
        this.input = input;
        this.tag = tag;
        this.severity = severity;
        this.message = message;
        this.note = note;
        this.cause = cause;
    }

    public Input input() {
        return this.input.clone();
    }

    public Tag tag() {
        return this.tag;
    }

    public Severity severity() {
        return this.severity;
    }

    public String message() {
        return this.message;
    }

    public String note() {
        return this.note;
    }

    public Diagnostic cause() {
        return this.cause;
    }

    private int lineDigits() {
        int digits = Base10.countDigits(this.tag.end().line());
        if (this.cause != null) {
            digits = Math.max(digits, this.cause.lineDigits());
        }
        return digits;
    }

    @Override
    public <T> Output<T> display(Output<T> output) {
        Input input = this.input.clone();
        Mark start = this.tag.start();
        Mark end = this.tag.end();
        Severity severity = this.severity;
        String message = this.message;
        String note = this.note;
        Diagnostic cause = this.cause;
        int contextLines = 2;
        int lineDigits = this.lineDigits();
        output = Diagnostic.display(output, input, start, end, severity, message, note, cause, 2, lineDigits);
        return output;
    }

    static <T> Output<T> display(Output<T> output, Input input, Mark start, Mark end, Severity severity, String message, String note, Diagnostic cause, int contextLines, int lineDigits) {
        while (true) {
            if (message != null) {
                output = Diagnostic.displayMessage(output, severity, message);
                output = output.writeln();
            }
            output = Diagnostic.displayAnchor(output, input, start, lineDigits);
            output = output.writeln();
            Map.Entry<Diagnostic, Output<T>> cont = Diagnostic.displayContext(output, input, start, end, severity, note, cause, contextLines, lineDigits);
            Diagnostic next = cont.getKey();
            output = cont.getValue();
            if (next == null) break;
            output = output.writeln();
            input = next.input.clone();
            start = next.tag.start();
            end = next.tag.end();
            severity = next.severity;
            message = next.message;
            note = next.note;
            cause = next.cause;
        }
        return output;
    }

    static <T> Output<T> displayMessage(Output<T> output, Severity severity, String message) {
        output = Diagnostic.formatSeverity(output, severity);
        output = output.write(severity.label());
        output = OutputStyle.reset(output);
        output = OutputStyle.bold(output);
        output = output.write(58);
        if (message != null) {
            output = output.write(32).write(message);
        }
        output = OutputStyle.reset(output);
        return output;
    }

    static <T> Output<T> displayAnchor(Output<T> output, Input input, Mark start, int lineDigits) {
        output = Diagnostic.displayLineLeadArrow(output, lineDigits);
        output = output.write(32);
        Object id = input.id();
        if (id != null) {
            output = Format.display(output, id);
        }
        output = output.write(58);
        output = Format.displayInt(output, start.line);
        output = output.write(58);
        output = Format.displayInt(output, start.column);
        output = output.writeln();
        output = Diagnostic.displayLineLead(output, lineDigits);
        return output;
    }

    static <T> Map.Entry<Diagnostic, Output<T>> displayContext(Output<T> output, Input input, Mark start, Mark end, Severity severity, String note, Diagnostic cause, int contextLines, int lineDigits) {
        Map.Entry<Diagnostic, Output<T>> cont;
        int causeOrder;
        boolean sameCause;
        Diagnostic next = cause;
        boolean bl = sameCause = cause != null && cause.message == null && Objects.equals(input.id(), cause.input.id());
        int n = sameCause ? (start.offset <= cause.tag.start().offset ? -1 : 1) : (causeOrder = 0);
        if (causeOrder == 1) {
            cont = Diagnostic.displayContext(output, cause.input.clone(), cause.tag.start(), cause.tag.end(), cause.severity, cause.note, cause.cause, contextLines, lineDigits);
            next = cont.getKey();
            output = cont.getValue();
            output = output.writeln();
            output = Diagnostic.displayLineLeadEllipsis(output, lineDigits);
            output = output.writeln();
        }
        output = Diagnostic.displayLines(output, input, start, end, severity, contextLines, lineDigits);
        if (note != null) {
            output = Diagnostic.displayNote(output, note, lineDigits);
        }
        if (causeOrder == -1) {
            output = output.writeln();
            output = Diagnostic.displayLineLeadEllipsis(output, lineDigits);
            output = output.writeln();
            cont = Diagnostic.displayContext(output, cause.input.clone(), cause.tag.start(), cause.tag.end(), cause.severity, cause.note, cause.cause, contextLines, lineDigits);
            next = cont.getKey();
            output = cont.getValue();
        }
        return new AbstractMap.SimpleImmutableEntry<Diagnostic, Output<T>>(next, output);
    }

    static <T> Output<T> displayLines(Output<T> output, Input input, Mark start, Mark end, Severity severity, int contextLines, int lineDigits) {
        int line;
        int startLine = start.line();
        int endLine = end.line();
        for (line = input.line(); line < startLine; ++line) {
            Diagnostic.consumeLineText(input, line);
        }
        if (endLine - startLine > 2 * contextLines + 2) {
            while (line <= startLine + contextLines) {
                output = Diagnostic.displayLine(output, input, start, end, severity, line, lineDigits);
                ++line;
            }
            output = Diagnostic.displayLineLeadEllipsis(output, lineDigits);
            output = output.write(32);
            output = Diagnostic.formatSeverity(output, severity);
            output = output.write(124);
            output = OutputStyle.reset(output);
            output = output.writeln();
            while (line < endLine - contextLines) {
                Diagnostic.consumeLineText(input, line);
                ++line;
            }
        }
        while (line <= endLine) {
            output = Diagnostic.displayLine(output, input, start, end, severity, line, lineDigits);
            ++line;
        }
        return output;
    }

    static <T> Output<T> displayNote(Output<T> output, String note, int lineDigits) {
        output = output.writeln();
        output = Diagnostic.displayLineLead(output, lineDigits);
        output = output.writeln();
        output = Diagnostic.displayLineComment(output, "note", note, lineDigits);
        return output;
    }

    static <T> Output<T> displayLine(Output<T> output, Input input, Mark start, Mark end, Severity severity, int line, int lineDigits) {
        output = start.line == line && end.line == line ? Diagnostic.displaySingleLine(output, input, start, end, severity, line, lineDigits) : (start.line == line ? Diagnostic.displayStartLine(output, input, start, severity, line, lineDigits) : (end.line == line ? Diagnostic.displayEndLine(output, input, end, severity, line, lineDigits) : Diagnostic.displayMidLine(output, input, severity, line, lineDigits)));
        return output;
    }

    static <T> Output<T> displaySingleLine(Output<T> output, Input input, Mark start, Mark end, Severity severity, int line, int lineDigits) {
        int i;
        output = Diagnostic.displayLineLeadNumber(output, line, lineDigits);
        output = output.write(32);
        for (i = 1; i < input.column(); ++i) {
            output = output.write(32);
        }
        output = Diagnostic.displayLineText(output, input, line);
        output = Diagnostic.displayLineLead(output, lineDigits);
        output = output.write(32);
        for (i = 1; i < start.column; ++i) {
            output = output.write(32);
        }
        output = Diagnostic.formatSeverity(output, severity);
        while (i <= end.column) {
            output = output.write(94);
            ++i;
        }
        if (end.note != null) {
            output = output.write(32).write(end.note);
        }
        output = OutputStyle.reset(output);
        return output;
    }

    static <T> Output<T> displayStartLine(Output<T> output, Input input, Mark start, Severity severity, int line, int lineDigits) {
        int i;
        output = Diagnostic.displayLineLeadNumber(output, line, lineDigits);
        output = output.write(32).write(32).write(32);
        for (i = 1; i < input.column(); ++i) {
            output = output.write(32);
        }
        output = Diagnostic.displayLineText(output, input, line);
        output = Diagnostic.displayLineLead(output, lineDigits);
        output = output.write(32).write(32);
        output = Diagnostic.formatSeverity(output, severity);
        output = output.write(95);
        for (i = 1; i < start.column; ++i) {
            output = output.write(95);
        }
        output = output.write(94);
        if (start.note != null) {
            output = output.write(32).write(start.note);
        }
        output = OutputStyle.reset(output);
        output = output.writeln();
        return output;
    }

    static <T> Output<T> displayEndLine(Output<T> output, Input input, Mark end, Severity severity, int line, int lineDigits) {
        output = Diagnostic.displayLineLeadNumber(output, line, lineDigits);
        output = output.write(32);
        output = Diagnostic.formatSeverity(output, severity);
        output = output.write(124);
        output = OutputStyle.reset(output);
        output = output.write(32);
        output = Diagnostic.displayLineText(output, input, line);
        output = Diagnostic.displayLineLead(output, lineDigits);
        output = output.write(32);
        output = Diagnostic.formatSeverity(output, severity);
        output = output.write(124).write(95);
        for (int i = 1; i < end.column; ++i) {
            output = output.write(95);
        }
        output = output.write(94);
        if (end.note != null) {
            output = output.write(32).write(end.note);
        }
        output = OutputStyle.reset(output);
        return output;
    }

    static <T> Output<T> displayMidLine(Output<T> output, Input input, Severity severity, int line, int lineDigits) {
        output = Diagnostic.displayLineLeadNumber(output, line, lineDigits);
        output = output.write(32);
        output = Diagnostic.formatSeverity(output, severity);
        output = output.write(124);
        output = OutputStyle.reset(output);
        output = output.write(32);
        output = Diagnostic.displayLineText(output, input, line);
        return output;
    }

    static <T> Output<T> displayLineComment(Output<T> output, String label, String comment, int lineDigits) {
        output = Diagnostic.displayLineLeadComment(output, lineDigits);
        output = output.write(32);
        output = OutputStyle.bold(output);
        output = output.write(label).write(58);
        output = OutputStyle.reset(output);
        if (comment != null) {
            output = output.write(32).write(comment);
        }
        return output;
    }

    static <T> Output<T> displayLineLead(Output<T> output, int lineDigits) {
        output = OutputStyle.blueBold(output);
        int padding = 1 + lineDigits;
        for (int i = 0; i < padding; ++i) {
            output = output.write(32);
        }
        output = output.write(124);
        output = OutputStyle.reset(output);
        return output;
    }

    static <T> Output<T> displayLineLeadComment(Output<T> output, int lineDigits) {
        output = OutputStyle.blueBold(output);
        int padding = 1 + lineDigits;
        for (int i = 0; i < padding; ++i) {
            output = output.write(32);
        }
        output = output.write(61);
        output = OutputStyle.reset(output);
        return output;
    }

    static <T> Output<T> displayLineLeadArrow(Output<T> output, int lineDigits) {
        for (int i = 0; i < lineDigits; ++i) {
            output = output.write(32);
        }
        output = OutputStyle.blueBold(output);
        output = output.write(45).write(45).write(62);
        output = OutputStyle.reset(output);
        return output;
    }

    static <T> Output<T> displayLineLeadEllipsis(Output<T> output, int lineDigits) {
        output = OutputStyle.blueBold(output);
        for (int i = 0; i < lineDigits; ++i) {
            output = output.write(46);
        }
        output = OutputStyle.reset(output);
        output = output.write(32).write(32);
        return output;
    }

    static <T> Output<T> displayLineLeadNumber(Output<T> output, int line, int lineDigits) {
        int padding = lineDigits - Base10.countDigits(line);
        for (int i = 0; i < padding; ++i) {
            output = output.write(32);
        }
        output = OutputStyle.blueBold(output);
        output = Format.displayInt(output, line);
        output = output.write(32).write(124);
        output = OutputStyle.reset(output);
        return output;
    }

    static <T> Output<T> displayLineText(Output<T> output, Input input, int line) {
        while (input.isCont() && input.line() == line) {
            output = output.write(input.head());
            input = input.step();
        }
        if (input.line() == line) {
            output = output.writeln();
        }
        return output;
    }

    static void consumeLineText(Input input, int line) {
        while (input.isCont() && input.line() == line) {
            input = input.step();
        }
    }

    static <T> Output<T> formatSeverity(Output<T> output, Severity severity) {
        switch (severity.level()) {
            case 5: 
            case 6: 
            case 7: {
                output = OutputStyle.redBold(output);
                break;
            }
            case 4: {
                output = OutputStyle.yellowBold(output);
                break;
            }
            case 3: {
                output = OutputStyle.greenBold(output);
                break;
            }
            case 2: {
                output = OutputStyle.cyanBold(output);
                break;
            }
            default: {
                output = OutputStyle.magentaBold(output);
            }
        }
        return output;
    }

    public String toString(OutputSettings settings) {
        return Format.display(this, settings);
    }

    public String toString() {
        return Format.display(this);
    }

    public static Diagnostic create(Input input, Tag tag, Severity severity, String message, String note, Diagnostic cause) {
        input = input.clone();
        tag = Objects.requireNonNull(tag);
        severity = Objects.requireNonNull(severity);
        return new Diagnostic(input, tag, severity, message, note, cause);
    }

    public static Diagnostic create(Input input, Tag tag, Severity severity, String message, String note) {
        return Diagnostic.create(input, tag, severity, message, note, null);
    }

    public static Diagnostic create(Input input, Tag tag, Severity severity, String message, Diagnostic cause) {
        return Diagnostic.create(input, tag, severity, message, null, cause);
    }

    public static Diagnostic create(Input input, Tag tag, Severity severity, String message) {
        return Diagnostic.create(input, tag, severity, message, null, null);
    }

    public static Diagnostic create(Input input, Tag tag, Severity severity, Diagnostic cause) {
        return Diagnostic.create(input, tag, severity, null, null, cause);
    }

    public static Diagnostic create(Input input, Tag tag, Severity severity) {
        return Diagnostic.create(input, tag, severity, null, null, null);
    }

    public static Diagnostic message(String message, Input input, Severity severity, String note, Diagnostic cause) {
        Mark mark = input.mark();
        Input source = input.clone().seek(null);
        return Diagnostic.create(source, mark, severity, message, note, cause);
    }

    public static Diagnostic message(String message, Input input, Severity severity, String note) {
        return Diagnostic.message(message, input, severity, note, null);
    }

    public static Diagnostic message(String message, Input input, Severity severity, Diagnostic cause) {
        return Diagnostic.message(message, input, severity, null, cause);
    }

    public static Diagnostic message(String message, Input input, Severity severity) {
        return Diagnostic.message(message, input, severity, null, null);
    }

    public static Diagnostic message(String message, Input input, String note, Diagnostic cause) {
        return Diagnostic.message(message, input, Severity.error(), note, cause);
    }

    public static Diagnostic message(String message, Input input, String note) {
        return Diagnostic.message(message, input, Severity.error(), note, null);
    }

    public static Diagnostic message(String message, Input input, Diagnostic cause) {
        return Diagnostic.message(message, input, Severity.error(), null, cause);
    }

    public static Diagnostic message(String message, Input input) {
        return Diagnostic.message(message, input, Severity.error(), null, null);
    }

    public static Diagnostic unexpected(Input input, Severity severity, String note, Diagnostic cause) {
        String message;
        if (input.isCont()) {
            Output<String> output = Unicode.stringOutput().write("unexpected").write(32);
            output = Format.debugChar(output, input.head());
            message = output.bind();
        } else {
            message = "unexpected end of input";
        }
        Mark mark = input.mark();
        Input source = input.clone().seek(null);
        return Diagnostic.create(source, mark, severity, message, note, cause);
    }

    public static Diagnostic unexpected(Input input, Severity severity, String note) {
        return Diagnostic.unexpected(input, severity, note, null);
    }

    public static Diagnostic unexpected(Input input, Severity severity, Diagnostic cause) {
        return Diagnostic.unexpected(input, severity, null, cause);
    }

    public static Diagnostic unexpected(Input input, Severity severity) {
        return Diagnostic.unexpected(input, severity, null, null);
    }

    public static Diagnostic unexpected(Input input, String note, Diagnostic cause) {
        return Diagnostic.unexpected(input, Severity.error(), note, cause);
    }

    public static Diagnostic unexpected(Input input, String note) {
        return Diagnostic.unexpected(input, Severity.error(), note, null);
    }

    public static Diagnostic unexpected(Input input, Diagnostic cause) {
        return Diagnostic.unexpected(input, Severity.error(), null, cause);
    }

    public static Diagnostic unexpected(Input input) {
        return Diagnostic.unexpected(input, Severity.error(), null, null);
    }

    public static Diagnostic expected(int expected, Input input, Severity severity, String note, Diagnostic cause) {
        Output<String> output = Unicode.stringOutput().write("expected").write(32);
        output = Format.debugChar(output, expected);
        output = output.write(", ").write("but found").write(32);
        output = input.isCont() ? Format.debugChar(output, input.head()) : output.write("end of input");
        String message = output.bind();
        Mark mark = input.mark();
        Input source = input.clone().seek(null);
        return Diagnostic.create(source, mark, severity, message, note, cause);
    }

    public static Diagnostic expected(int expected, Input input, Severity severity, String note) {
        return Diagnostic.expected(expected, input, severity, note, null);
    }

    public static Diagnostic expected(int expected, Input input, Severity severity, Diagnostic cause) {
        return Diagnostic.expected(expected, input, severity, null, cause);
    }

    public static Diagnostic expected(int expected, Input input, Severity severity) {
        return Diagnostic.expected(expected, input, severity, null, null);
    }

    public static Diagnostic expected(int expected, Input input, String note, Diagnostic cause) {
        return Diagnostic.expected(expected, input, Severity.error(), note, cause);
    }

    public static Diagnostic expected(int expected, Input input, String note) {
        return Diagnostic.expected(expected, input, Severity.error(), note, null);
    }

    public static Diagnostic expected(int expected, Input input, Diagnostic cause) {
        return Diagnostic.expected(expected, input, Severity.error(), null, cause);
    }

    public static Diagnostic expected(int expected, Input input) {
        return Diagnostic.expected(expected, input, Severity.error(), null, null);
    }

    public static Diagnostic expected(String expected, Input input, Severity severity, String note, Diagnostic cause) {
        Output<String> output = Unicode.stringOutput().write("expected").write(32).write(expected).write(", ").write("but found").write(32);
        output = input.isCont() ? Format.debugChar(output, input.head()) : output.write("end of input");
        String message = output.bind();
        Mark mark = input.mark();
        Input source = input.clone().seek(null);
        return Diagnostic.create(source, mark, severity, message, note, cause);
    }

    public static Diagnostic expected(String expected, Input input, Severity severity, String note) {
        return Diagnostic.expected(expected, input, severity, note, null);
    }

    public static Diagnostic expected(String expected, Input input, Severity severity, Diagnostic cause) {
        return Diagnostic.expected(expected, input, severity, null, cause);
    }

    public static Diagnostic expected(String expected, Input input, Severity severity) {
        return Diagnostic.expected(expected, input, severity, null, null);
    }

    public static Diagnostic expected(String expected, Input input, String note, Diagnostic cause) {
        return Diagnostic.expected(expected, input, Severity.error(), note, cause);
    }

    public static Diagnostic expected(String expected, Input input, String note) {
        return Diagnostic.expected(expected, input, Severity.error(), note, null);
    }

    public static Diagnostic expected(String expected, Input input, Diagnostic cause) {
        return Diagnostic.expected(expected, input, Severity.error(), null, cause);
    }

    public static Diagnostic expected(String expected, Input input) {
        return Diagnostic.expected(expected, input, Severity.error(), null, null);
    }
}

