/*
 * Decompiled with CFR 0.152.
 */
package swim.codec;

import swim.codec.Decoder;
import swim.codec.InputBuffer;

public abstract class DynamicDecoder<O>
extends Decoder<O> {
    protected Decoder<? extends O> decoding;

    @Override
    public Decoder<O> feed(InputBuffer input) {
        Decoder<O> decoder = this.decoding;
        if (decoder == null) {
            if (input.isDone()) {
                return Decoder.done();
            }
            decoder = this.doDecode();
            this.decoding = decoder;
            if (decoder == null) {
                return Decoder.done();
            }
        }
        if (decoder != null) {
            if ((decoder = decoder.feed(input)).isDone()) {
                this.decoding = null;
                this.didDecode(decoder.bind());
            } else if (decoder.isError()) {
                return decoder.asError();
            }
        }
        if (input.isDone()) {
            return Decoder.done();
        }
        return this;
    }

    @Override
    public Decoder<O> fork(Object condition) {
        if (this.decoding != null) {
            this.decoding = this.decoding.fork(condition);
        }
        return this;
    }

    @Override
    public O bind() {
        if (this.decoding != null) {
            return this.decoding.bind();
        }
        throw new IllegalStateException();
    }

    @Override
    public Throwable trap() {
        if (this.decoding != null) {
            return this.decoding.trap();
        }
        throw new IllegalStateException();
    }

    protected abstract Decoder<? extends O> doDecode();

    protected abstract void didDecode(O var1);
}

