/*
 * Decompiled with CFR 0.152.
 */
package swim.codec;

import swim.codec.Debug;
import swim.codec.Format;
import swim.codec.Output;
import swim.util.Murmur3;

public class InputSettings
implements Debug {
    protected final boolean isStripped;
    private static int hashSeed;
    private static InputSettings standard;
    private static InputSettings stripped;

    protected InputSettings(boolean isStripped) {
        this.isStripped = isStripped;
    }

    public final boolean isStripped() {
        return this.isStripped;
    }

    public InputSettings isStripped(boolean isStripped) {
        return this.copy(isStripped);
    }

    protected InputSettings copy(boolean isStripped) {
        return InputSettings.create(isStripped);
    }

    protected boolean canEqual(Object other) {
        return other instanceof InputSettings;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof InputSettings) {
            InputSettings that = (InputSettings)other;
            return that.canEqual(this) && this.isStripped == that.isStripped;
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(InputSettings.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)hashSeed, (int)Murmur3.hash((boolean)this.isStripped)));
    }

    @Override
    public <T> Output<T> debug(Output<T> output) {
        output = output.write("InputSettings").write(46);
        output = !this.isStripped ? output.write("standard") : output.write("stripped");
        output = output.write(40).write(41);
        return output;
    }

    public String toString() {
        return Format.debug(this);
    }

    public static final InputSettings standard() {
        if (standard == null) {
            standard = new InputSettings(false);
        }
        return standard;
    }

    public static final InputSettings stripped() {
        if (stripped == null) {
            stripped = new InputSettings(true);
        }
        return stripped;
    }

    public static final InputSettings create(boolean isStripped) {
        if (isStripped) {
            return InputSettings.stripped();
        }
        return InputSettings.standard();
    }
}

