/*
 * Decompiled with CFR 0.152.
 */
package swim.codec;

import swim.codec.Input;
import swim.codec.Parser;

final class LineParser
extends Parser<String> {
    final StringBuilder output;

    LineParser(StringBuilder output) {
        this.output = output;
    }

    LineParser() {
        this(null);
    }

    @Override
    public Parser<String> feed(Input input) {
        return LineParser.parse(input, this.output);
    }

    static Parser<String> parse(Input input, StringBuilder output) {
        if (output == null) {
            output = new StringBuilder();
        }
        while (input.isCont()) {
            int c = input.head();
            input = input.step();
            if (c == 13) continue;
            if (c != 10) {
                output.appendCodePoint(c);
                continue;
            }
            return Parser.done(output.toString());
        }
        if (input.isDone()) {
            return Parser.done(output.toString());
        }
        if (input.isError()) {
            return Parser.error(input.trap());
        }
        return new LineParser(output);
    }
}

