/*
 * Decompiled with CFR 0.152.
 */
package swim.codec;

import java.util.Objects;
import swim.codec.Format;
import swim.codec.Output;
import swim.codec.Span;
import swim.codec.Tag;
import swim.util.Murmur3;

public final class Mark
extends Tag
implements Comparable<Mark> {
    final long offset;
    final int line;
    final int column;
    final String note;
    private static int hashSeed;
    private static Mark zero;

    Mark(long offset, int line, int column, String note) {
        this.offset = offset;
        this.line = line;
        this.column = column;
        this.note = note;
    }

    public long offset() {
        return this.offset;
    }

    public int line() {
        return this.line;
    }

    public int column() {
        return this.column;
    }

    public String note() {
        return this.note;
    }

    public Mark min(Mark that) {
        if (this.offset <= that.offset) {
            return this;
        }
        return that;
    }

    public Mark max(Mark that) {
        if (this.offset >= that.offset) {
            return this;
        }
        return that;
    }

    @Override
    public Mark start() {
        return this;
    }

    @Override
    public Mark end() {
        return this;
    }

    @Override
    public Tag union(Tag other) {
        if (other instanceof Mark) {
            Mark that = (Mark)other;
            if (this.offset == that.offset && this.line == that.line && this.column == that.column) {
                return this;
            }
            return Span.from(this, that);
        }
        if (other instanceof Span) {
            Span that = (Span)other;
            Mark start = this.min(that.start);
            Mark end = this.max(that.end);
            if (start == that.start && end == that.end) {
                return that;
            }
            return Span.from(start, end);
        }
        throw new UnsupportedOperationException(other.toString());
    }

    @Override
    public Mark shift(Mark mark) {
        long offset = this.offset + (this.offset - mark.offset);
        int line = this.line + (this.line - mark.line);
        int column = this.column;
        if (line == 1) {
            column += this.column - mark.column;
        }
        if (offset == this.offset && line == this.line && column == this.column) {
            return this;
        }
        return Mark.at(offset, line, column, this.note);
    }

    @Override
    public int compareTo(Mark that) {
        return Long.compare(this.offset, that.offset);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof Mark) {
            Mark that = (Mark)other;
            return this.offset == that.offset && this.line == that.line && this.column == that.column && Objects.equals(this.note, that.note);
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(Mark.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)hashSeed, (int)Murmur3.hash((long)this.offset)), (int)this.line), (int)this.column), (int)Murmur3.hash((Object)this.note)));
    }

    @Override
    public <T> Output<T> display(Output<T> output) {
        output = Format.displayInt(output, this.line);
        output = output.write(58);
        output = Format.displayInt(output, this.column);
        if (this.note != null) {
            output = output.write(": ").write(this.note);
        }
        return output;
    }

    @Override
    public <T> Output<T> debug(Output<T> output) {
        output = output.write("Mark").write(46).write("at").write(40);
        output = Format.debugLong(output, this.offset);
        output = output.write(", ");
        output = Format.debugInt(output, this.line);
        output = output.write(", ");
        output = Format.debugInt(output, this.column);
        if (this.note != null) {
            output = output.write(", ");
            output = Format.debugString(output, this.note);
        }
        output = output.write(41);
        return output;
    }

    public String toString() {
        return Format.display(this);
    }

    public static Mark zero() {
        if (zero == null) {
            zero = new Mark(0L, 1, 1, null);
        }
        return zero;
    }

    public static Mark at(long offset, int line, int column, String note) {
        return new Mark(offset, line, column, note);
    }

    public static Mark at(long offset, int line, int column) {
        return new Mark(offset, line, column, null);
    }
}

