/*
 * Decompiled with CFR 0.152.
 */
package swim.codec;

import swim.codec.Format;
import swim.codec.OutputDone;
import swim.codec.OutputError;
import swim.codec.OutputException;
import swim.codec.OutputFull;
import swim.codec.OutputSettings;

public abstract class Output<T> {
    private static Output<Object> full;
    private static Output<Object> done;

    public abstract boolean isCont();

    public abstract boolean isFull();

    public abstract boolean isDone();

    public abstract boolean isError();

    public abstract boolean isPart();

    public abstract Output<T> isPart(boolean var1);

    public abstract Output<T> write(int var1);

    public Output<T> write(String string) {
        Output<T> output = this;
        int n = string.length();
        int i = 0;
        while (i < n) {
            output = output.write(string.codePointAt(i));
            i = string.offsetByCodePoints(i, 1);
        }
        return output;
    }

    public Output<T> writeln(String string) {
        return this.write(string).writeln();
    }

    public Output<T> writeln() {
        return this.write(this.settings().lineSeparator());
    }

    public Output<T> display(Object object) {
        return Format.display(this, object);
    }

    public Output<T> debug(Object object) {
        return Format.debug(this, object);
    }

    public Output<T> flush() {
        return this;
    }

    public Output<T> fork(Object condition) {
        return this;
    }

    public abstract T bind();

    public Throwable trap() {
        throw new OutputException();
    }

    public abstract OutputSettings settings();

    public abstract Output<T> settings(OutputSettings var1);

    public Output<T> clone() {
        throw new UnsupportedOperationException();
    }

    public static <T> Output<T> full() {
        if (full == null) {
            full = new OutputFull<Object>(null, OutputSettings.standard());
        }
        return full;
    }

    public static <T> Output<T> full(OutputSettings settings) {
        if (settings == OutputSettings.standard()) {
            return Output.full();
        }
        return new OutputFull<Object>(null, settings);
    }

    public static <T> Output<T> full(T value) {
        if (value == null) {
            return Output.full();
        }
        return new OutputFull<T>(value, OutputSettings.standard());
    }

    public static <T> Output<T> full(T value, OutputSettings settings) {
        if (value == null && settings == OutputSettings.standard()) {
            return Output.full();
        }
        return new OutputFull<T>(value, settings);
    }

    public static <T> Output<T> done() {
        if (done == null) {
            done = new OutputDone<Object>(null, OutputSettings.standard());
        }
        return done;
    }

    public static <T> Output<T> done(OutputSettings settings) {
        if (settings == OutputSettings.standard()) {
            return Output.done();
        }
        return new OutputDone<Object>(null, settings);
    }

    public static <T> Output<T> done(T value) {
        if (value == null) {
            return Output.done();
        }
        return new OutputDone<T>(value, OutputSettings.standard());
    }

    public static <T> Output<T> done(T value, OutputSettings settings) {
        if (value == null && settings == OutputSettings.standard()) {
            return Output.done();
        }
        return new OutputDone<T>(value, settings);
    }

    public static <T> Output<T> error(Throwable error) {
        return new OutputError(error, OutputSettings.standard());
    }

    public static <T> Output<T> error(Throwable error, OutputSettings settings) {
        return new OutputError(error, settings);
    }
}

