/*
 * Decompiled with CFR 0.152.
 */
package swim.codec;

import java.io.IOException;
import java.nio.channels.ReadableByteChannel;
import swim.codec.Format;
import swim.codec.Output;
import swim.codec.OutputBufferDone;
import swim.codec.OutputBufferError;
import swim.codec.OutputBufferFull;
import swim.codec.OutputSettings;

public abstract class OutputBuffer<T>
extends Output<T> {
    private static OutputBuffer<Object> full;
    private static OutputBuffer<Object> done;

    @Override
    public abstract OutputBuffer<T> isPart(boolean var1);

    public abstract int index();

    public abstract OutputBuffer<T> index(int var1);

    public abstract int limit();

    public abstract OutputBuffer<T> limit(int var1);

    public abstract int capacity();

    public abstract int remaining();

    public abstract byte[] array();

    public abstract int arrayOffset();

    public abstract boolean has(int var1);

    public abstract int get(int var1);

    public abstract void set(int var1, int var2);

    public abstract int write(ReadableByteChannel var1) throws IOException;

    @Override
    public abstract OutputBuffer<T> write(int var1);

    @Override
    public OutputBuffer<T> write(String string) {
        Output output = this;
        int n = string.length();
        int i = 0;
        while (i < n) {
            output = output.write(string.codePointAt(i));
            i = string.offsetByCodePoints(i, 1);
        }
        return output;
    }

    @Override
    public OutputBuffer<T> writeln(String string) {
        return ((OutputBuffer)this.write(string)).writeln();
    }

    @Override
    public OutputBuffer<T> writeln() {
        return this.write(this.settings().lineSeparator());
    }

    @Override
    public OutputBuffer<T> display(Object object) {
        Output output = Format.display(this, object);
        if (output instanceof OutputBuffer) {
            return (OutputBuffer)output;
        }
        return OutputBuffer.error(output.trap());
    }

    @Override
    public OutputBuffer<T> debug(Object object) {
        Output output = Format.debug(this, object);
        if (output instanceof OutputBuffer) {
            return (OutputBuffer)output;
        }
        return OutputBuffer.error(output.trap());
    }

    public abstract OutputBuffer<T> move(int var1, int var2, int var3);

    public abstract OutputBuffer<T> step(int var1);

    @Override
    public OutputBuffer<T> flush() {
        return this;
    }

    @Override
    public OutputBuffer<T> fork(Object condition) {
        return this;
    }

    @Override
    public abstract OutputBuffer<T> settings(OutputSettings var1);

    @Override
    public OutputBuffer<T> clone() {
        throw new UnsupportedOperationException();
    }

    public static <T> OutputBuffer<T> full() {
        if (full == null) {
            full = new OutputBufferFull<Object>(null, OutputSettings.standard());
        }
        return full;
    }

    public static <T> OutputBuffer<T> full(OutputSettings settings) {
        if (settings == OutputSettings.standard()) {
            return OutputBuffer.full();
        }
        return new OutputBufferFull<Object>(null, settings);
    }

    public static <T> OutputBuffer<T> full(T value) {
        if (value == null) {
            return OutputBuffer.full();
        }
        return new OutputBufferFull<T>(value, OutputSettings.standard());
    }

    public static <T> OutputBuffer<T> full(T value, OutputSettings settings) {
        if (value == null && settings == OutputSettings.standard()) {
            return OutputBuffer.full();
        }
        return new OutputBufferFull<T>(value, settings);
    }

    public static <T> OutputBuffer<T> done() {
        if (done == null) {
            done = new OutputBufferDone<Object>(null, OutputSettings.standard());
        }
        return done;
    }

    public static <T> OutputBuffer<T> done(OutputSettings settings) {
        if (settings == OutputSettings.standard()) {
            return OutputBuffer.done();
        }
        return new OutputBufferDone<Object>(null, settings);
    }

    public static <T> OutputBuffer<T> done(T value) {
        if (value == null) {
            return OutputBuffer.done();
        }
        return new OutputBufferDone<T>(value, OutputSettings.standard());
    }

    public static <T> OutputBuffer<T> done(T value, OutputSettings settings) {
        if (value == null && settings == OutputSettings.standard()) {
            return OutputBuffer.done();
        }
        return new OutputBufferDone<T>(value, settings);
    }

    public static <T> OutputBuffer<T> error(Throwable error) {
        return new OutputBufferError(error, OutputSettings.standard());
    }

    public static <T> OutputBuffer<T> error(Throwable error, OutputSettings settings) {
        return new OutputBufferError(error, settings);
    }
}

