/*
 * Decompiled with CFR 0.152.
 */
package swim.codec;

import swim.codec.Base16;
import swim.codec.Input;
import swim.codec.InputException;
import swim.codec.InputSettings;
import swim.codec.Mark;
import swim.codec.Output;
import swim.codec.Unicode;
import swim.codec.UtfErrorMode;

final class Utf8DecodedInput
extends Input {
    Input input;
    UtfErrorMode errorMode;
    long offset;
    int line;
    int column;
    int c1;
    int c2;
    int c3;
    int have;
    int state;
    InputException error;
    private static final int DECODE = -1;
    private static final int EMPTY = -2;
    private static final int DONE = -3;
    private static final int ERROR = -4;

    Utf8DecodedInput(Input input, UtfErrorMode errorMode, long offset, int line, int column, int c1, int c2, int c3, int have, int state, InputException error) {
        this.input = input;
        this.errorMode = errorMode;
        this.offset = offset;
        this.line = line;
        this.column = column;
        this.c1 = c1;
        this.c2 = c2;
        this.c3 = c3;
        this.have = have;
        this.state = state;
        this.error = error;
    }

    Utf8DecodedInput(Input input, UtfErrorMode errorMode) {
        this(input, errorMode, 0L, 1, 1, -1, -1, -1, 0, -1, null);
    }

    @Override
    public boolean isCont() {
        return this.state() >= 0;
    }

    @Override
    public boolean isEmpty() {
        return this.state() == -2;
    }

    @Override
    public boolean isDone() {
        return this.state() == -3;
    }

    @Override
    public boolean isError() {
        return this.state() == -4;
    }

    @Override
    public boolean isPart() {
        return this.input.isPart();
    }

    @Override
    public Input isPart(boolean isPart) {
        this.input = this.input.isPart(isPart);
        return this;
    }

    int state() {
        if (this.state == -1) {
            int c1;
            Input input = this.input;
            if (this.c1 >= 0) {
                c1 = this.c1;
            } else if (input.isCont()) {
                c1 = input.head();
                input = input.step();
            } else {
                c1 = -1;
            }
            if (c1 == 0 && this.errorMode.isNonZero()) {
                this.have = 1;
                this.state = -4;
                this.error = new InputException("invalid NUL byte");
            } else if (c1 >= 0 && c1 <= 127) {
                this.have = 1;
                this.state = c1;
            } else if (c1 >= 194 && c1 <= 244) {
                int c2 = this.c2 >= 0 ? this.c2 : (input.isCont() ? input.head() : -1);
                if (c1 >= 194 && c1 <= 223 && c2 >= 128 && c2 <= 191) {
                    if (this.c2 < 0) {
                        input = input.step();
                    }
                    this.have = 2;
                    this.state = (c1 & 0x1F) << 6 | c2 & 0x3F;
                } else if (c1 == 224 && c2 >= 160 && c2 <= 191 || c1 >= 225 && c1 <= 236 && c2 >= 128 && c2 <= 191 || c1 == 237 && c2 >= 128 && c2 <= 159 || c1 >= 238 && c1 <= 239 && c2 >= 128 && c2 <= 191) {
                    int c3;
                    if (this.c2 < 0) {
                        input = input.step();
                    }
                    if ((c3 = this.c3 >= 0 ? this.c3 : (input.isCont() ? input.head() : -1)) >= 128 && c3 <= 191) {
                        if (this.c3 < 0) {
                            input = input.step();
                        }
                        this.have = 3;
                        this.state = (c1 & 0xF) << 12 | (c2 & 0x3F) << 6 | c3 & 0x3F;
                    } else if (c3 >= 0) {
                        this.have = 2;
                        if (this.errorMode.isFatal()) {
                            this.state = -4;
                            this.error = new InputException(Utf8DecodedInput.invalid(c1, c2, c3));
                        } else {
                            this.state = this.errorMode.replacementChar();
                        }
                    } else if (input.isDone()) {
                        this.have = 2;
                        if (this.errorMode.isFatal()) {
                            this.state = -4;
                            this.error = new InputException(Utf8DecodedInput.invalid(c1, c2));
                        } else {
                            this.state = this.errorMode.replacementChar();
                        }
                    } else if (input.isEmpty()) {
                        this.c1 = c1;
                        this.c2 = c2;
                        this.state = -2;
                    }
                } else if (c1 == 240 && c2 >= 144 && c2 <= 191 || c1 >= 241 && c1 <= 243 && c2 >= 128 && c2 <= 191 || c1 == 244 && c2 >= 128 && c2 <= 143) {
                    int c3;
                    if (this.c2 < 0) {
                        input = input.step();
                    }
                    if ((c3 = this.c3 >= 0 ? this.c3 : (input.isCont() ? input.head() : -1)) >= 128 && c3 <= 191) {
                        int c4;
                        if (this.c3 < 0) {
                            input = input.step();
                        }
                        if ((c4 = input.isCont() ? input.head() : -1) >= 128 && c4 <= 191) {
                            input = input.step();
                            this.have = 4;
                            this.state = (c1 & 7) << 18 | (c2 & 0x3F) << 12 | (c3 & 0x3F) << 6 | c4 & 0x3F;
                        } else if (c4 >= 0) {
                            this.have = 3;
                            if (this.errorMode.isFatal()) {
                                this.state = -4;
                                this.error = new InputException(Utf8DecodedInput.invalid(c1, c2, c3, c4));
                            } else {
                                this.state = this.errorMode.replacementChar();
                            }
                        } else if (input.isDone()) {
                            this.have = 3;
                            if (this.errorMode.isFatal()) {
                                this.state = -4;
                                this.error = new InputException(Utf8DecodedInput.invalid(c1, c2, c3));
                            } else {
                                this.state = this.errorMode.replacementChar();
                            }
                        } else if (input.isEmpty()) {
                            this.c1 = c1;
                            this.c2 = c2;
                            this.c3 = c3;
                            this.state = -2;
                        }
                    } else if (c3 >= 0) {
                        this.have = 2;
                        if (this.errorMode.isFatal()) {
                            this.state = -4;
                            this.error = new InputException(Utf8DecodedInput.invalid(c1, c2, c3));
                        } else {
                            this.state = this.errorMode.replacementChar();
                        }
                    } else if (input.isDone()) {
                        this.have = 2;
                        if (this.errorMode.isFatal()) {
                            this.state = -4;
                            this.error = new InputException(Utf8DecodedInput.invalid(c1, c2));
                        } else {
                            this.state = this.errorMode.replacementChar();
                        }
                    } else if (input.isEmpty()) {
                        this.c1 = c1;
                        this.c2 = c2;
                        this.state = -2;
                    }
                } else if (c2 >= 0) {
                    this.have = 1;
                    if (this.errorMode.isFatal()) {
                        this.state = -4;
                        this.error = new InputException(Utf8DecodedInput.invalid(c1, c2));
                    } else {
                        this.state = this.errorMode.replacementChar();
                    }
                } else if (input.isDone()) {
                    this.have = 1;
                    if (this.errorMode.isFatal()) {
                        this.state = -4;
                        this.error = new InputException(Utf8DecodedInput.invalid(c1));
                    } else {
                        this.state = this.errorMode.replacementChar();
                    }
                } else if (input.isEmpty()) {
                    this.c1 = c1;
                    this.state = -2;
                }
            } else if (c1 >= 0) {
                this.have = 1;
                if (this.errorMode.isFatal()) {
                    this.state = -4;
                    this.error = new InputException(Utf8DecodedInput.invalid(c1));
                } else {
                    this.state = this.errorMode.replacementChar();
                }
            } else if (input.isDone()) {
                this.state = -3;
            } else if (input.isEmpty()) {
                this.state = -2;
            }
            this.input = input;
        }
        return this.state;
    }

    @Override
    public int head() {
        int state = this.state();
        if (state < 0) {
            throw new InputException();
        }
        return state;
    }

    @Override
    public Input step() {
        int state = this.state();
        if (state >= 0) {
            this.offset += (long)this.have;
            if (state == 10) {
                ++this.line;
                this.column = 1;
            } else {
                ++this.column;
            }
            this.c1 = -1;
            this.c2 = -1;
            this.c3 = -1;
            this.have = 0;
            this.state = -1;
            return this;
        }
        InputException error = new InputException("invalid step");
        return Input.error(error, this.input.id(), this.mark(), this.input.settings());
    }

    @Override
    public Input fork(Object condition) {
        if (condition instanceof Input) {
            this.input = (Input)condition;
            this.state = -1;
        }
        return this;
    }

    @Override
    public Throwable trap() {
        if (this.state() == -4) {
            return this.error;
        }
        throw new IllegalStateException();
    }

    @Override
    public Input seek(Mark mark) {
        this.input = this.input.seek(mark);
        if (mark != null) {
            this.offset = mark.offset;
            this.line = mark.line;
            this.column = mark.column;
        } else {
            this.offset = 0L;
            this.line = 1;
            this.column = 1;
        }
        this.c1 = -1;
        this.c2 = -1;
        this.c3 = -1;
        this.have = 0;
        this.state = -1;
        this.error = null;
        return this;
    }

    @Override
    public Object id() {
        return this.input.id();
    }

    @Override
    public Input id(Object id) {
        this.input = this.input.id(id);
        return this;
    }

    @Override
    public Mark mark() {
        return Mark.at(this.offset, this.line, this.column);
    }

    @Override
    public Input mark(Mark mark) {
        this.input = this.input.mark(mark);
        this.offset = mark.offset;
        this.line = mark.line;
        this.column = mark.column;
        return this;
    }

    @Override
    public long offset() {
        return this.offset;
    }

    @Override
    public int line() {
        return this.line;
    }

    @Override
    public int column() {
        return this.column;
    }

    @Override
    public InputSettings settings() {
        return this.input.settings();
    }

    @Override
    public Input settings(InputSettings settings) {
        this.input = this.input.settings(settings);
        return this;
    }

    @Override
    public Input clone() {
        return new Utf8DecodedInput(this.input.clone(), this.errorMode, this.offset, this.line, this.column, this.c1, this.c2, this.c3, this.have, this.state, this.error);
    }

    private static String invalid(int c1) {
        Output<String> output = Unicode.stringOutput();
        output = output.write("invalid UTF-8 code unit: ");
        Base16.uppercase().writeIntLiteral(output, c1, 2).bind();
        return output.bind();
    }

    private static String invalid(int c1, int c2) {
        Output<String> output = Unicode.stringOutput();
        output = output.write("invalid UTF-8 code unit sequence: ");
        Base16.uppercase().writeIntLiteral(output, c1, 2).bind();
        output = output.write(32);
        Base16.uppercase().writeIntLiteral(output, c2, 2).bind();
        return output.bind();
    }

    private static String invalid(int c1, int c2, int c3) {
        Output<String> output = Unicode.stringOutput();
        output = output.write("invalid UTF-8 code unit sequence: ");
        Base16.uppercase().writeIntLiteral(output, c1, 2).bind();
        output = output.write(32);
        Base16.uppercase().writeIntLiteral(output, c2, 2).bind();
        output = output.write(32);
        Base16.uppercase().writeIntLiteral(output, c3, 2).bind();
        return output.bind();
    }

    private static String invalid(int c1, int c2, int c3, int c4) {
        Output<String> output = Unicode.stringOutput();
        output = output.write("invalid UTF-8 code unit sequence: ");
        Base16.uppercase().writeIntLiteral(output, c1, 2).bind();
        output = output.write(32);
        Base16.uppercase().writeIntLiteral(output, c2, 2).bind();
        output = output.write(32);
        Base16.uppercase().writeIntLiteral(output, c3, 2).bind();
        output = output.write(32);
        Base16.uppercase().writeIntLiteral(output, c4, 2).bind();
        return output.bind();
    }
}

