/*
 * Decompiled with CFR 0.152.
 */
package swim.codec;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import swim.codec.ByteArrayInput;
import swim.codec.ByteArrayOutput;
import swim.codec.ByteBufferInput;
import swim.codec.ByteBufferOutput;
import swim.codec.ByteOutputArray;
import swim.codec.ByteOutputBuffer;
import swim.codec.ByteParser;
import swim.codec.ByteWriter;
import swim.codec.ChannelEncoder;
import swim.codec.Decoder;
import swim.codec.Encoder;
import swim.codec.Input;
import swim.codec.InputBuffer;
import swim.codec.NullParser;
import swim.codec.Output;
import swim.codec.OutputBuffer;
import swim.codec.OutputSettings;
import swim.codec.Parser;
import swim.codec.Writer;

public final class Binary {
    private Binary() {
    }

    public static InputBuffer input(byte ... bytes) {
        return new ByteArrayInput(bytes, 0, bytes.length);
    }

    public static InputBuffer inputBuffer(byte[] array, int offset, int length) {
        return new ByteArrayInput(array, offset, length);
    }

    public static InputBuffer inputBuffer(byte[] array) {
        return new ByteArrayInput(array, 0, array.length);
    }

    public static InputBuffer inputBuffer(ByteBuffer buffer) {
        return new ByteBufferInput(buffer);
    }

    public static OutputBuffer<ByteBuffer> outputBuffer(byte[] array, int offset, int length) {
        return new ByteArrayOutput(array, offset, length);
    }

    public static OutputBuffer<ByteBuffer> outputBuffer(byte[] array) {
        return new ByteArrayOutput(array, 0, array.length);
    }

    public static OutputBuffer<ByteBuffer> outputBuffer(ByteBuffer buffer) {
        return new ByteBufferOutput(buffer);
    }

    public static Output<byte[]> byteArrayOutput(int initialCapacity, OutputSettings settings) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException(Integer.toString(initialCapacity));
        }
        return new ByteOutputArray(new byte[initialCapacity], 0, settings);
    }

    public static Output<byte[]> byteArrayOutput(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException(Integer.toString(initialCapacity));
        }
        return new ByteOutputArray(new byte[initialCapacity], 0, OutputSettings.standard());
    }

    public static Output<byte[]> byteArrayOutput(OutputSettings settings) {
        return new ByteOutputArray(null, 0, settings);
    }

    public static Output<byte[]> byteArrayOutput(byte[] array) {
        return new ByteOutputArray(array, array.length, OutputSettings.standard());
    }

    public static Output<byte[]> byteArrayOutput() {
        return new ByteOutputArray(null, 0, OutputSettings.standard());
    }

    public static Output<ByteBuffer> byteBufferOutput(int initialCapacity, OutputSettings settings) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException(Integer.toString(initialCapacity));
        }
        return new ByteOutputBuffer(new byte[initialCapacity], 0, settings);
    }

    public static Output<ByteBuffer> byteBufferOutput(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException(Integer.toString(initialCapacity));
        }
        return new ByteOutputBuffer(new byte[initialCapacity], 0, OutputSettings.standard());
    }

    public static Output<ByteBuffer> byteBufferOutput(OutputSettings settings) {
        return new ByteOutputBuffer(null, 0, settings);
    }

    public static Output<ByteBuffer> byteBufferOutput(byte[] array) {
        return new ByteOutputBuffer(array, array.length, OutputSettings.standard());
    }

    public static Output<ByteBuffer> byteBufferOutput() {
        return new ByteOutputBuffer(null, 0, OutputSettings.standard());
    }

    public static <O> Parser<O> outputParser(Output<O> output) {
        return new ByteParser<O>(output);
    }

    public static <O> Parser<O> parseOutput(Input input, Output<O> output) {
        return ByteParser.parse(input, output);
    }

    public static <O> Parser<O> nullParser() {
        return new NullParser();
    }

    public static <O> Parser<O> parseNull(Input input) {
        return NullParser.parse(input);
    }

    public static Writer<byte[], ?> byteArrayWriter() {
        return new ByteWriter();
    }

    public static Writer<Object, byte[]> byteArrayWriter(byte[] input) {
        return new ByteWriter((Object)input, input);
    }

    public static <O> Writer<Object, O> byteArrayWriter(O value, byte[] input) {
        return new ByteWriter(value, input);
    }

    public static Writer<ByteBuffer, Object> byteBufferWriter() {
        return new ByteWriter();
    }

    public static Writer<Object, ByteBuffer> byteBufferWriter(ByteBuffer input) {
        return new ByteWriter((Object)input, input);
    }

    public static <O> Writer<Object, O> byteBufferEWriter(O value, ByteBuffer input) {
        return new ByteWriter(value, input);
    }

    public static Writer<Object, Object> writeByteArray(Output<?> output, byte[] input) {
        return ByteWriter.write(output, null, input);
    }

    public static Writer<Object, Object> writeByteBuffer(Output<?> output, ByteBuffer input) {
        return ByteWriter.write(output, null, input);
    }

    public static Encoder<ReadableByteChannel, ReadableByteChannel> channelEncoder() {
        return new ChannelEncoder();
    }

    public static Encoder<ReadableByteChannel, ReadableByteChannel> channelEncoder(ReadableByteChannel input) {
        return new ChannelEncoder(input);
    }

    public static <O> Decoder<O> decode(InputStream input, Decoder<O> decoder) throws IOException {
        byte[] data = new byte[4096];
        InputBuffer buffer = Binary.inputBuffer(data);
        do {
            int count = input.read(data);
            buffer.index(0).limit(Math.max(0, count)).isPart(count >= 0);
        } while ((decoder = decoder.feed(buffer)).isCont());
        return decoder;
    }

    public static <O> O read(InputStream input, Decoder<O> decoder) throws IOException {
        if ((decoder = Binary.decode(input, decoder)).isDone()) {
            return decoder.bind();
        }
        Throwable error = decoder.trap();
        if (error instanceof RuntimeException) {
            throw (RuntimeException)error;
        }
        throw new RuntimeException(error);
    }
}

