/*
 * Decompiled with CFR 0.152.
 */
package swim.codec;

import swim.codec.Debug;
import swim.codec.Display;
import swim.codec.Output;
import swim.codec.OutputSettings;
import swim.codec.Unicode;

public final class Format {
    private static String lineSeparator;

    private Format() {
    }

    public static <T> Output<T> display(Output<T> output, Object object) {
        output = object == null ? output.write("null") : (object instanceof Integer ? Format.displayInt(output, (Integer)object) : (object instanceof Long ? Format.displayLong(output, (Long)object) : (object instanceof Display ? ((Display)object).display(output) : output.write(object.toString()))));
        return output;
    }

    public static String display(Object object, OutputSettings settings) {
        if (object == null) {
            return "null";
        }
        if (object instanceof Display) {
            Output<String> output = Unicode.stringOutput(settings);
            output = ((Display)object).display(output);
            return output.bind();
        }
        return object.toString();
    }

    public static String display(Object object) {
        return Format.display(object, OutputSettings.standard());
    }

    public static <T> Output<T> debug(Output<T> output, Object object) {
        output = object == null ? output.write("null") : (object instanceof Integer ? Format.debugInt(output, (Integer)object) : (object instanceof Long ? Format.debugLong(output, (Long)object) : (object instanceof Float ? Format.debugFloat(output, ((Float)object).floatValue()) : (object instanceof Character ? Format.debugChar(output, ((Character)object).charValue()) : (object instanceof String ? Format.debugString(output, (String)object) : (object instanceof Debug ? ((Debug)object).debug(output) : output.write(object.toString())))))));
        return output;
    }

    public static String debug(Object object, OutputSettings settings) {
        if (object == null) {
            return "null";
        }
        if (object instanceof Integer) {
            Output<String> output = Unicode.stringOutput(settings);
            output = Format.debugInt(output, (Integer)object);
            return output.bind();
        }
        if (object instanceof Long) {
            Output<String> output = Unicode.stringOutput(settings);
            output = Format.debugLong(output, (Long)object);
            return output.bind();
        }
        if (object instanceof Float) {
            Output<String> output = Unicode.stringOutput(settings);
            output = Format.debugFloat(output, ((Float)object).floatValue());
            return output.bind();
        }
        if (object instanceof Character) {
            Output<String> output = Unicode.stringOutput(settings);
            output = Format.debugChar(output, ((Character)object).charValue());
            return output.bind();
        }
        if (object instanceof String) {
            Output<String> output = Unicode.stringOutput(settings);
            output = Format.debugString(output, (String)object);
            return output.bind();
        }
        if (object instanceof Debug) {
            Output<String> output = Unicode.stringOutput(settings);
            output = ((Debug)object).debug(output);
            return output.bind();
        }
        return object.toString();
    }

    public static String debug(Object object) {
        return Format.debug(object, OutputSettings.standard());
    }

    public static <T> Output<T> displayInt(Output<T> output, int value) {
        if (value < 0) {
            output = output.write(45);
        }
        if (value > -10 && value < 10) {
            output = output.write(48 + Math.abs(value));
        } else {
            byte[] digits = new byte[10];
            long x = value;
            int i = 9;
            while (x != 0L) {
                digits[i] = (byte)Math.abs(x % 10L);
                x /= 10L;
                --i;
            }
            ++i;
            while (i < 10) {
                output = output.write(48 + digits[i]);
                ++i;
            }
        }
        return output;
    }

    public static <T> Output<T> displayLong(Output<T> output, long value) {
        if (value < 0L) {
            output = output.write(45);
        }
        if (value > -10L && value < 10L) {
            output = output.write(48 + Math.abs((int)value));
        } else {
            byte[] digits = new byte[19];
            long x = value;
            int i = 18;
            while (x != 0L) {
                digits[i] = (byte)Math.abs((int)(x % 10L));
                x /= 10L;
                --i;
            }
            ++i;
            while (i < 19) {
                output = output.write(48 + digits[i]);
                ++i;
            }
        }
        return output;
    }

    public static <T> Output<T> displayFloat(Output<T> output, float value) {
        output = output.write(Float.toString(value)).write(102);
        return output;
    }

    public static <T> Output<T> displayDouble(Output<T> output, double value) {
        output = output.write(Double.toString(value));
        return output;
    }

    public static <T> Output<T> debugInt(Output<T> output, int value) {
        output = Format.displayInt(output, value);
        return output;
    }

    public static <T> Output<T> debugLong(Output<T> output, long value) {
        output = Format.displayLong(output, value);
        output = output.write(76);
        return output;
    }

    public static <T> Output<T> debugFloat(Output<T> output, float value) {
        output = output.write(Float.toString(value)).write(102);
        return output;
    }

    public static <T> Output<T> debugDouble(Output<T> output, double value) {
        output = output.write(Double.toString(value));
        return output;
    }

    public static <T> Output<T> debugChar(Output<T> output, int value) {
        output = output.write(39);
        switch (value) {
            case 8: {
                output = output.write(92).write(98);
                break;
            }
            case 9: {
                output = output.write(92).write(116);
                break;
            }
            case 10: {
                output = output.write(92).write(110);
                break;
            }
            case 12: {
                output = output.write(92).write(102);
                break;
            }
            case 13: {
                output = output.write(92).write(114);
                break;
            }
            case 34: {
                output = output.write(92).write(34);
                break;
            }
            case 39: {
                output = output.write(92).write(39);
                break;
            }
            case 92: {
                output = output.write(92).write(92);
                break;
            }
            default: {
                output = value >= 0 && value <= 31 || value >= 127 && value <= 159 ? output.write(92).write(117).write(Format.encodeHex(value >>> 12 & 0xF)).write(Format.encodeHex(value >>> 8 & 0xF)).write(Format.encodeHex(value >>> 4 & 0xF)).write(Format.encodeHex(value & 0xF)) : output.write(value);
            }
        }
        output = output.write(39);
        return output;
    }

    public static <T> Output<T> debugString(Output<T> output, String value) {
        output = output.write(34);
        int n = value.length();
        int i = 0;
        while (i < n) {
            int c = value.codePointAt(i);
            switch (c) {
                case 8: {
                    output = output.write(92).write(98);
                    break;
                }
                case 9: {
                    output = output.write(92).write(116);
                    break;
                }
                case 10: {
                    output = output.write(92).write(110);
                    break;
                }
                case 12: {
                    output = output.write(92).write(102);
                    break;
                }
                case 13: {
                    output = output.write(92).write(114);
                    break;
                }
                case 34: {
                    output = output.write(92).write(34);
                    break;
                }
                case 92: {
                    output = output.write(92).write(92);
                    break;
                }
                default: {
                    output = c >= 0 && c <= 31 || c >= 127 && c <= 159 ? output.write(92).write(117).write(Format.encodeHex(c >>> 12 & 0xF)).write(Format.encodeHex(c >>> 8 & 0xF)).write(Format.encodeHex(c >>> 4 & 0xF)).write(Format.encodeHex(c & 0xF)) : output.write(c);
                }
            }
            i = value.offsetByCodePoints(i, 1);
        }
        output = output.write(34);
        return output;
    }

    private static char encodeHex(int x) {
        if (x < 10) {
            return (char)(48 + x);
        }
        return (char)(65 + (x - 10));
    }

    public static String lineSeparator() {
        if (lineSeparator == null) {
            lineSeparator = System.getProperty("line.separator", "\n");
        }
        return lineSeparator;
    }
}

