/*
 * Decompiled with CFR 0.152.
 */
package swim.codec;

import swim.codec.Debug;
import swim.codec.Format;
import swim.codec.Output;
import swim.util.Murmur3;

public class OutputSettings
implements Debug {
    protected final String lineSeparator;
    protected final boolean isPretty;
    protected final boolean isStyled;
    private static int hashSeed;
    private static OutputSettings standard;
    private static OutputSettings pretty;
    private static OutputSettings styled;
    private static OutputSettings prettyStyled;

    protected OutputSettings(String lineSeparator, boolean isPretty, boolean isStyled) {
        this.lineSeparator = lineSeparator;
        this.isPretty = isPretty;
        this.isStyled = isStyled;
    }

    public final String lineSeparator() {
        return this.lineSeparator;
    }

    public OutputSettings lineSeparator(String lineSeparator) {
        return this.copy(lineSeparator, this.isPretty, this.isStyled);
    }

    public final boolean isPretty() {
        return this.isPretty;
    }

    public OutputSettings isPretty(boolean isPretty) {
        return this.copy(this.lineSeparator, isPretty, this.isStyled);
    }

    public final boolean isStyled() {
        return this.isStyled;
    }

    public OutputSettings isStyled(boolean isStyled) {
        return this.copy(this.lineSeparator, this.isPretty, isStyled);
    }

    protected OutputSettings copy(String lineSeparator, boolean isPretty, boolean isStyled) {
        return OutputSettings.create(lineSeparator, isPretty, isStyled);
    }

    protected boolean canEqual(Object other) {
        return other instanceof OutputSettings;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof OutputSettings) {
            OutputSettings that = (OutputSettings)other;
            return that.canEqual(this) && this.lineSeparator.equals(that.lineSeparator) && this.isPretty == that.isPretty && this.isStyled == that.isStyled;
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(OutputSettings.class);
        }
        return Murmur3.mash((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)hashSeed, (int)this.lineSeparator.hashCode()), (int)Murmur3.hash((boolean)this.isPretty)), (int)Murmur3.hash((boolean)this.isStyled)));
    }

    @Override
    public <T> Output<T> debug(Output<T> output) {
        output = output.write("OutputSettings").write(46);
        output = !this.isPretty && !this.isStyled ? output.write("standard") : (this.isPretty && !this.isStyled ? output.write("pretty") : (!this.isPretty && this.isStyled ? output.write("styled") : output.write("prettyStyled")));
        output = output.write(40).write(41);
        if (!Format.lineSeparator().equals(this.lineSeparator)) {
            output = output.write(46).write("lineSeparator").write(40).display(this.lineSeparator).write(41);
        }
        return output;
    }

    public String toString() {
        return Format.debug(this);
    }

    public static final OutputSettings standard() {
        if (standard == null) {
            standard = new OutputSettings(Format.lineSeparator(), false, false);
        }
        return standard;
    }

    public static final OutputSettings pretty() {
        if (pretty == null) {
            pretty = new OutputSettings(Format.lineSeparator(), true, false);
        }
        return pretty;
    }

    public static final OutputSettings styled() {
        if (styled == null) {
            styled = new OutputSettings(Format.lineSeparator(), false, true);
        }
        return styled;
    }

    public static final OutputSettings prettyStyled() {
        if (prettyStyled == null) {
            prettyStyled = new OutputSettings(Format.lineSeparator(), true, true);
        }
        return prettyStyled;
    }

    public static final OutputSettings create(String lineSeparator, boolean isPretty, boolean isStyled) {
        if (lineSeparator == null) {
            lineSeparator = Format.lineSeparator();
        }
        if (Format.lineSeparator().equals(lineSeparator)) {
            if (!isPretty && !isStyled) {
                return OutputSettings.standard();
            }
            if (isPretty && !isStyled) {
                return OutputSettings.pretty();
            }
            if (!isPretty && isStyled) {
                return OutputSettings.styled();
            }
            return OutputSettings.prettyStyled();
        }
        return new OutputSettings(lineSeparator, isPretty, isStyled);
    }
}

