/*
 * Decompiled with CFR 0.152.
 */
package swim.codec;

import swim.codec.Base16;
import swim.codec.Output;
import swim.codec.OutputException;
import swim.codec.OutputSettings;
import swim.codec.Unicode;
import swim.codec.UtfErrorMode;

final class Utf8DecodedOutput<T>
extends Output<T> {
    Output<T> output;
    final UtfErrorMode errorMode;
    int c1;
    int c2;
    int c3;
    int have;

    Utf8DecodedOutput(Output<T> output, UtfErrorMode errorMode, int c1, int c2, int c3, int have) {
        this.output = output;
        this.errorMode = errorMode;
        this.c1 = c1;
        this.c2 = c2;
        this.c3 = c3;
        this.have = have;
    }

    Utf8DecodedOutput(Output<T> output, UtfErrorMode errorMode) {
        this(output, errorMode, -1, -1, -1, 0);
    }

    @Override
    public boolean isCont() {
        return this.output.isCont();
    }

    @Override
    public boolean isFull() {
        return this.output.isFull();
    }

    @Override
    public boolean isDone() {
        return this.output.isDone();
    }

    @Override
    public boolean isError() {
        return this.output.isError();
    }

    @Override
    public boolean isPart() {
        return this.output.isPart();
    }

    @Override
    public Output<T> isPart(boolean isPart) {
        this.output = this.output.isPart(isPart);
        return this;
    }

    @Override
    public Output<T> write(int c) {
        int c1 = this.c1;
        int c2 = this.c2;
        int c3 = this.c3;
        int c4 = -1;
        int have = this.have;
        if (c >= 0) {
            switch (have) {
                case 0: {
                    c1 = c & 0xFF;
                    have = 1;
                    break;
                }
                case 1: {
                    c2 = c & 0xFF;
                    have = 2;
                    break;
                }
                case 2: {
                    c3 = c & 0xFF;
                    have = 3;
                    break;
                }
                case 3: {
                    c4 = c & 0xFF;
                    have = 4;
                    break;
                }
                default: {
                    throw new AssertionError((Object)"unreachable");
                }
            }
        }
        if (c1 == 0 && this.errorMode.isNonZero()) {
            return Output.error(new OutputException("unexpected NUL byte"));
        }
        if (c1 >= 0 && c1 <= 127) {
            this.output = this.output.write(c1);
            this.have = 0;
        } else if (c1 >= 194 && c1 <= 244) {
            if (c1 >= 194 && c1 <= 223 && c2 >= 128 && c2 <= 191) {
                this.output = this.output.write((c1 & 0x1F) << 6 | c2 & 0x3F);
                this.c1 = -1;
                this.have = 0;
            } else if (c1 == 224 && c2 >= 160 && c2 <= 191 || c1 >= 225 && c1 <= 236 && c2 >= 128 && c2 <= 191 || c1 == 237 && c2 >= 128 && c2 <= 159 || c1 >= 238 && c1 <= 239 && c2 >= 128 && c2 <= 191) {
                if (c3 >= 128 && c3 <= 191) {
                    this.output = this.output.write((c1 & 0xF) << 12 | (c2 & 0x3F) << 6 | c3 & 0x3F);
                    this.c1 = -1;
                    this.c2 = -1;
                    this.have = 0;
                } else if (c3 >= 0) {
                    if (this.errorMode.isFatal()) {
                        return Output.error(new OutputException(Utf8DecodedOutput.invalid(c1, c2, c3)));
                    }
                    this.output = this.output.write(this.errorMode.replacementChar());
                    this.c1 = c3;
                    this.c2 = -1;
                    this.have = 1;
                } else {
                    if (c < 0 || this.output.isDone()) {
                        return Output.error(new OutputException(Utf8DecodedOutput.invalid(c1, c2)));
                    }
                    this.c2 = c2;
                    this.have = 2;
                }
            } else if (c1 == 240 && c2 >= 144 && c2 <= 191 || c1 >= 241 && c1 <= 243 && c2 >= 128 && c2 <= 191 || c1 == 244 && c2 >= 128 && c2 <= 143) {
                if (c3 >= 128 && c3 <= 191) {
                    if (c4 >= 128 && c4 <= 191) {
                        this.have = 4;
                        this.output = this.output.write((c1 & 7) << 18 | (c2 & 0x3F) << 12 | (c3 & 0x3F) << 6 | c4 & 0x3F);
                        this.c1 = -1;
                        this.c2 = -1;
                        this.c3 = -1;
                        this.have = 0;
                    } else if (c4 >= 0) {
                        if (this.errorMode.isFatal()) {
                            return Output.error(new OutputException(Utf8DecodedOutput.invalid(c1, c2, c3, c4)));
                        }
                        this.output = this.output.write(this.errorMode.replacementChar());
                        this.c1 = c4;
                        this.c2 = -1;
                        this.c3 = -1;
                        this.have = 1;
                    } else {
                        if (c < 0 || this.output.isDone()) {
                            return Output.error(new OutputException(Utf8DecodedOutput.invalid(c1, c2, c3)));
                        }
                        this.c3 = c3;
                        this.have = 3;
                    }
                } else if (c3 >= 0) {
                    if (this.errorMode.isFatal()) {
                        return Output.error(new OutputException(Utf8DecodedOutput.invalid(c1, c2, c3)));
                    }
                    this.output = this.output.write(this.errorMode.replacementChar());
                    this.c1 = c3;
                    this.c2 = -1;
                    this.have = 1;
                } else {
                    if (c < 0 || this.output.isDone()) {
                        return Output.error(new OutputException(Utf8DecodedOutput.invalid(c1, c2)));
                    }
                    this.c2 = c2;
                    this.have = 2;
                }
            } else if (c2 >= 0) {
                if (this.errorMode.isFatal()) {
                    return Output.error(new OutputException(Utf8DecodedOutput.invalid(c1, c2)));
                }
                this.output = this.output.write(this.errorMode.replacementChar());
                this.c1 = c2;
                this.have = 1;
            } else {
                if (c < 0 || this.output.isDone()) {
                    return Output.error(new OutputException(Utf8DecodedOutput.invalid(c1)));
                }
                this.c1 = c1;
                this.have = 1;
            }
        } else if (c1 >= 0) {
            if (this.errorMode.isFatal()) {
                return Output.error(new OutputException(Utf8DecodedOutput.invalid(c1)));
            }
            this.output = this.output.write(this.errorMode.replacementChar());
            this.have = 0;
        }
        if (this.output.isError()) {
            return this.output;
        }
        return this;
    }

    @Override
    public OutputSettings settings() {
        return this.output.settings();
    }

    @Override
    public Output<T> settings(OutputSettings settings) {
        this.output = this.output.settings(settings);
        return this;
    }

    @Override
    public Output<T> fork(Object condition) {
        this.output = this.output.fork(condition);
        return this;
    }

    @Override
    public T bind() {
        if (this.have == 0) {
            return this.output.bind();
        }
        return this.write(-1).bind();
    }

    @Override
    public Throwable trap() {
        return this.output.trap();
    }

    @Override
    public Output<T> clone() {
        return new Utf8DecodedOutput<T>(this.output.clone(), this.errorMode, this.c1, this.c2, this.c3, this.have);
    }

    private static String invalid(int c1) {
        Output<String> output = Unicode.stringOutput();
        output = output.write("invalid UTF-8 code unit: ");
        Base16.uppercase().writeIntLiteral(output, c1, 2).bind();
        return output.bind();
    }

    private static String invalid(int c1, int c2) {
        Output<String> output = Unicode.stringOutput();
        output = output.write("invalid UTF-8 code unit sequence: ");
        Base16.uppercase().writeIntLiteral(output, c1, 2).bind();
        output = output.write(32);
        Base16.uppercase().writeIntLiteral(output, c2, 2).bind();
        return output.bind();
    }

    private static String invalid(int c1, int c2, int c3) {
        Output<String> output = Unicode.stringOutput();
        output = output.write("invalid UTF-8 code unit sequence: ");
        Base16.uppercase().writeIntLiteral(output, c1, 2).bind();
        output = output.write(32);
        Base16.uppercase().writeIntLiteral(output, c2, 2).bind();
        output = output.write(32);
        Base16.uppercase().writeIntLiteral(output, c3, 2).bind();
        return output.bind();
    }

    private static String invalid(int c1, int c2, int c3, int c4) {
        Output<String> output = Unicode.stringOutput();
        output = output.write("invalid UTF-8 code unit sequence: ");
        Base16.uppercase().writeIntLiteral(output, c1, 2).bind();
        output = output.write(32);
        Base16.uppercase().writeIntLiteral(output, c2, 2).bind();
        output = output.write(32);
        Base16.uppercase().writeIntLiteral(output, c3, 2).bind();
        output = output.write(32);
        Base16.uppercase().writeIntLiteral(output, c4, 2).bind();
        return output.bind();
    }
}

