/*
 * Decompiled with CFR 0.152.
 */
package swim.codec;

import java.nio.ByteBuffer;
import swim.codec.Base16IntegerWriter;
import swim.codec.Base16Parser;
import swim.codec.Base16Writer;
import swim.codec.Binary;
import swim.codec.Format;
import swim.codec.Input;
import swim.codec.Output;
import swim.codec.Parser;
import swim.codec.Unicode;
import swim.codec.Writer;

public final class Base16 {
    final String alphabet;
    private static Base16 lowercase;
    private static Base16 uppercase;

    Base16(String alphabet) {
        this.alphabet = alphabet;
    }

    public String alphabet() {
        return this.alphabet;
    }

    public char encodeDigit(int b) {
        return this.alphabet.charAt(b);
    }

    public Writer<byte[], ?> byteArrayWriter() {
        return new Base16Writer(this);
    }

    public Writer<?, byte[]> byteArrayWriter(byte[] input) {
        return new Base16Writer(this, (Object)input, input);
    }

    public Writer<ByteBuffer, ?> byteBufferWriter() {
        return new Base16Writer(this);
    }

    public Writer<?, ByteBuffer> byteBufferWriter(ByteBuffer input) {
        return new Base16Writer(this, (Object)input, input);
    }

    public Writer<?, ?> writeByteArray(Output<?> output, byte[] input) {
        return Base16Writer.write(output, this, null, input);
    }

    public Writer<?, ?> writeByteBuffer(Output<?> output, ByteBuffer input) {
        return Base16Writer.write(output, this, null, input);
    }

    public Writer<?, ?> writeInt(Output<?> output, int input, int width) {
        return Base16IntegerWriter.write(output, this, null, input, width, false);
    }

    public Writer<?, ?> writeInt(Output<?> output, int input) {
        return Base16IntegerWriter.write(output, this, null, input, 0, false);
    }

    public Writer<?, ?> writeLong(Output<?> output, long input, int width) {
        return Base16IntegerWriter.write(output, this, null, input, width, false);
    }

    public Writer<?, ?> writeLong(Output<?> output, long input) {
        return Base16IntegerWriter.write(output, this, null, input, 0, false);
    }

    public Writer<?, ?> writeIntLiteral(Output<?> output, int input, int width) {
        return Base16IntegerWriter.write(output, this, null, input, width, true);
    }

    public Writer<?, ?> writeIntLiteral(Output<?> output, int input) {
        return Base16IntegerWriter.write(output, this, null, input, 0, true);
    }

    public Writer<?, ?> writeLongLiteral(Output<?> output, long input, int width) {
        return Base16IntegerWriter.write(output, this, null, input, width, true);
    }

    public Writer<?, ?> writeLongLiteral(Output<?> output, long input) {
        return Base16IntegerWriter.write(output, this, null, input, 0, true);
    }

    public static Base16 lowercase() {
        if (lowercase == null) {
            lowercase = new Base16("0123456789abcdef");
        }
        return lowercase;
    }

    public static Base16 uppercase() {
        if (uppercase == null) {
            uppercase = new Base16("0123456789ABCDEF");
        }
        return uppercase;
    }

    public static <O> Parser<O> parser(Output<O> output) {
        return new Base16Parser<O>(output);
    }

    public static <O> Parser<O> parse(Input input, Output<O> output) {
        return Base16Parser.parse(input, output);
    }

    public static Parser<byte[]> parseByteArray(Input input) {
        return Base16Parser.parse(input, Binary.byteArrayOutput());
    }

    public static Parser<ByteBuffer> parseByteBuffer(Input input) {
        return Base16Parser.parse(input, Binary.byteBufferOutput());
    }

    public static boolean isDigit(int c) {
        return c >= 48 && c <= 57 || c >= 65 && c <= 70 || c >= 97 && c <= 102;
    }

    public static int decodeDigit(int c) {
        if (c >= 48 && c <= 57) {
            return c - 48;
        }
        if (c >= 65 && c <= 70) {
            return 10 + (c - 65);
        }
        if (c >= 97 && c <= 102) {
            return 10 + (c - 97);
        }
        Output<String> message = Unicode.stringOutput();
        message = message.write("Invalid base-16 digit: ");
        message = Format.debugChar(message, c);
        throw new IllegalArgumentException(message.bind());
    }

    public static <T> Output<T> writeQuantum(Output<T> output, int c1, int c2) {
        int x = Base16.decodeDigit(c1);
        int y = Base16.decodeDigit(c2);
        output = output.write(x << 4 | y);
        return output;
    }
}

