/*
 * Decompiled with CFR 0.152.
 */
package swim.codec;

import swim.codec.Base16;
import swim.codec.Output;
import swim.codec.StringWriter;
import swim.codec.Writer;
import swim.codec.WriterException;

final class Base16IntegerWriter
extends Writer<Object, Object> {
    final Base16 base16;
    final Object value;
    final long input;
    final int width;
    final int index;
    final int step;

    Base16IntegerWriter(Base16 base16, Object value, long input, int width, int index, int step) {
        this.base16 = base16;
        this.value = value;
        this.input = input;
        this.width = width;
        this.index = index;
        this.step = step;
    }

    Base16IntegerWriter(Base16 base16, Object value, int input, int width, boolean literal) {
        this(base16, value, (long)input & 0xFFFFFFFFL, width, 0, literal ? 1 : 3);
    }

    Base16IntegerWriter(Base16 base16, Object value, long input, int width, boolean literal) {
        this(base16, value, input, width, 0, literal ? 1 : 3);
    }

    Base16IntegerWriter(Base16 base16, Object value, float input, int width, boolean literal) {
        this(base16, value, (long)Float.floatToIntBits(input) & 0xFFFFFFFFL, width, 0, literal ? 1 : 3);
    }

    Base16IntegerWriter(Base16 base16, Object value, double input, int width, boolean literal) {
        this(base16, value, Double.doubleToLongBits(input), width, 0, literal ? 1 : 3);
    }

    Base16IntegerWriter(Base16 base16, int width, boolean literal) {
        this(base16, null, 0L, width, 0, literal ? -1 : -3);
    }

    @Override
    public Writer<Object, Object> feed(Object input) {
        if (input instanceof Integer) {
            return new Base16IntegerWriter(this.base16, input, (Integer)input, this.width, this.step == -1);
        }
        if (input instanceof Long) {
            return new Base16IntegerWriter(this.base16, input, (Long)input, this.width, this.step == -1);
        }
        if (input instanceof Float) {
            return new Base16IntegerWriter(this.base16, input, ((Float)input).floatValue(), this.width, this.step == -1);
        }
        if (input instanceof Double) {
            return new Base16IntegerWriter(this.base16, input, (Double)input, this.width, this.step == -1);
        }
        return new StringWriter(input, input);
    }

    @Override
    public Writer<Object, Object> pull(Output<?> output) {
        return Base16IntegerWriter.write(output, this.base16, this.value, this.input, this.width, this.index, this.step);
    }

    static Writer<Object, Object> write(Output<?> output, Base16 base16, Object value, long input, int width, int index, int step) {
        if (step <= 0) {
            return Writer.done();
        }
        if (step == 1 && output.isCont()) {
            output = output.write(48);
            step = 2;
        }
        if (step == 2 && output.isCont()) {
            output = output.write(120);
            step = 3;
        }
        if (step == 3) {
            if (input >= 0L && input < 16L && width <= 1) {
                if (output.isCont()) {
                    output = output.write(base16.encodeDigit((int)input));
                    return Writer.done(value);
                }
            } else {
                int i = 15;
                int[] digits = new int[16];
                for (long x = input; x != 0L || i >= 16 - width; x >>>= 4, --i) {
                    digits[i] = (int)x & 0xF;
                }
                i += 1 + index;
                while (i < 16 && output.isCont()) {
                    output = output.write(base16.encodeDigit(digits[i]));
                    ++index;
                    ++i;
                }
                if (i == 16) {
                    return Writer.done(value);
                }
            }
        }
        if (output.isDone()) {
            return Writer.error(new WriterException("truncated"));
        }
        if (output.isError()) {
            return Writer.error(output.trap());
        }
        return new Base16IntegerWriter(base16, value, input, width, index, step);
    }

    static Writer<Object, Object> write(Output<?> output, Base16 base16, Object value, int input, int width, boolean literal) {
        return Base16IntegerWriter.write(output, base16, null, (long)input & 0xFFFFFFFFL, width, 0, literal ? 1 : 3);
    }

    static Writer<Object, Object> write(Output<?> output, Base16 base16, Object value, long input, int width, boolean literal) {
        return Base16IntegerWriter.write(output, base16, null, input, width, 0, literal ? 1 : 3);
    }

    static Writer<Object, Object> write(Output<?> output, Base16 base16, Object value, float input, int width, boolean literal) {
        return Base16IntegerWriter.write(output, base16, null, (long)Float.floatToIntBits(input) & 0xFFFFFFFFL, width, 0, literal ? 1 : 3);
    }

    static Writer<Object, Object> write(Output<?> output, Base16 base16, Object value, double input, int width, boolean literal) {
        return Base16IntegerWriter.write(output, base16, null, Double.doubleToLongBits(input), width, 0, literal ? 1 : 3);
    }
}

