/*
 * Decompiled with CFR 0.152.
 */
package swim.codec;

import swim.codec.Base16;
import swim.codec.Diagnostic;
import swim.codec.Input;
import swim.codec.Output;
import swim.codec.Parser;

final class Base16Parser<O>
extends Parser<O> {
    final Output<O> output;
    final int p;
    final int step;

    Base16Parser(Output<O> output, int p, int step) {
        this.output = output;
        this.p = p;
        this.step = step;
    }

    Base16Parser(Output<O> output) {
        this(output, 0, 1);
    }

    @Override
    public Parser<O> feed(Input input) {
        return Base16Parser.parse(input, this.output.clone(), this.p, this.step);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static <O> Parser<O> parse(Input input, Output<O> output, int p, int step) {
        int c = 0;
        while (!input.isEmpty()) {
            if (step == 1) {
                if (input.isCont()) {
                    c = input.head();
                    if (!Base16.isDigit(c)) return Parser.done(output.bind());
                    input = input.step();
                    p = c;
                    step = 2;
                } else if (input.isDone()) {
                    return Parser.done(output.bind());
                }
            }
            if (step != 2) continue;
            if (input.isCont()) {
                c = input.head();
                if (!Base16.isDigit(c)) return Parser.error(Diagnostic.expected("base16 digit", input));
                input = input.step();
                Base16.writeQuantum(output, p, c);
                p = 0;
                step = 1;
                continue;
            }
            if (!input.isDone()) continue;
            return Parser.error(Diagnostic.expected("base16 digit", input));
        }
        if (!input.isError()) return new Base16Parser<O>(output, p, step);
        return Parser.error(input.trap());
    }

    static <O> Parser<O> parse(Input input, Output<O> output) {
        return Base16Parser.parse(input, output, 0, 1);
    }
}

