/*
 * Decompiled with CFR 0.152.
 */
package swim.codec;

import java.nio.ByteBuffer;
import swim.codec.Base16;
import swim.codec.Output;
import swim.codec.Writer;
import swim.codec.WriterException;

final class Base16Writer
extends Writer<Object, Object> {
    final Base16 base16;
    final Object value;
    final ByteBuffer input;
    final int index;
    final int limit;
    final int step;

    Base16Writer(Base16 base16, Object value, ByteBuffer input, int index, int limit, int step) {
        this.base16 = base16;
        this.value = value;
        this.input = input;
        this.index = index;
        this.limit = limit;
        this.step = step;
    }

    Base16Writer(Base16 base16, Object value, ByteBuffer input) {
        this(base16, value, input, input.position(), input.limit(), 1);
    }

    Base16Writer(Base16 base16, Object value, byte[] input) {
        this(base16, value, ByteBuffer.wrap(input));
    }

    Base16Writer(Base16 base16) {
        this(base16, null, null, 0, 0, 1);
    }

    @Override
    public Writer<Object, Object> feed(Object value) {
        if (value instanceof ByteBuffer) {
            return new Base16Writer(this.base16, null, (ByteBuffer)value);
        }
        if (value instanceof byte[]) {
            return new Base16Writer(this.base16, null, (byte[])value);
        }
        throw new IllegalArgumentException(value.toString());
    }

    @Override
    public Writer<Object, Object> pull(Output<?> output) {
        return Base16Writer.write(output, this.base16, this.value, this.input, this.index, this.limit, this.step);
    }

    static Writer<Object, Object> write(Output<?> output, Base16 base16, Object value, ByteBuffer input, int index, int limit, int step) {
        while (index < limit) {
            int x = input.get(index) & 0xFF;
            if (step == 1 && output.isCont()) {
                output = output.write(base16.encodeDigit(x >>> 4));
                step = 2;
            }
            if (step != 2 || !output.isCont()) continue;
            output = output.write(base16.encodeDigit(x & 0xF));
            ++index;
            step = 1;
        }
        if (index == limit) {
            return Writer.done(value);
        }
        if (output.isDone()) {
            return Writer.error(new WriterException("truncated"));
        }
        if (output.isError()) {
            return Writer.error(output.trap());
        }
        return new Base16Writer(base16, value, input, index, limit, step);
    }

    static Writer<?, ?> write(Output<?> output, Base16 base16, Object value, ByteBuffer input) {
        return Base16Writer.write(output, base16, value, input, input.position(), input.limit(), 1);
    }

    static Writer<?, ?> write(Output<?> output, Base16 base16, Object value, byte[] input) {
        return Base16Writer.write(output, base16, value, ByteBuffer.wrap(input));
    }
}

