/*
 * Decompiled with CFR 0.152.
 */
package swim.codec;

import java.math.BigInteger;
import swim.codec.Input;
import swim.codec.Parser;

final class BigIntegerParser
extends Parser<Number> {
    final int sign;
    final BigInteger value;

    BigIntegerParser(int sign, BigInteger value) {
        this.sign = sign;
        this.value = value;
    }

    @Override
    public Parser<Number> feed(Input input) {
        return BigIntegerParser.parse(input, this.sign, this.value);
    }

    static Parser<Number> parse(Input input, int sign, BigInteger value) {
        int c;
        while (input.isCont() && (c = input.head()) >= 48 && c <= 57) {
            input = input.step();
            value = BigInteger.TEN.multiply(value).add(BigInteger.valueOf(sign * (c - 48)));
        }
        if (!input.isEmpty()) {
            return Parser.done(value);
        }
        return new BigIntegerParser(sign, value);
    }
}

