/*
 * Decompiled with CFR 0.152.
 */
package swim.codec;

import java.io.IOException;
import java.nio.channels.ReadableByteChannel;
import swim.codec.Encoder;
import swim.codec.OutputBuffer;

final class ChannelEncoder
extends Encoder<ReadableByteChannel, ReadableByteChannel> {
    final ReadableByteChannel input;

    ChannelEncoder(ReadableByteChannel input) {
        this.input = input;
    }

    ChannelEncoder() {
        this(null);
    }

    @Override
    public Encoder<ReadableByteChannel, ReadableByteChannel> feed(ReadableByteChannel input) {
        return new ChannelEncoder(input);
    }

    @Override
    public Encoder<ReadableByteChannel, ReadableByteChannel> pull(OutputBuffer<?> output) {
        ReadableByteChannel input = this.input;
        try {
            int k = output.write(input);
            if (k < 0 || !output.isPart()) {
                input.close();
                return Encoder.done(input);
            }
            if (output.isError()) {
                input.close();
                return Encoder.error(output.trap());
            }
            return this;
        }
        catch (IOException error) {
            try {
                input.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return Encoder.error(error);
        }
        catch (Throwable error) {
            try {
                input.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw error;
        }
    }
}

