/*
 * Decompiled with CFR 0.152.
 */
package swim.codec;

import swim.codec.Diagnostic;
import swim.codec.Input;
import swim.codec.NumberParser;
import swim.codec.Parser;

final class DecimalParser
extends Parser<Number> {
    final StringBuilder builder;
    final int mode;
    final int step;

    DecimalParser(StringBuilder builder, int mode, int step) {
        this.builder = builder;
        this.mode = mode;
        this.step = step;
    }

    @Override
    public Parser<Number> feed(Input input) {
        return DecimalParser.parse(input, this.builder, this.mode, this.step);
    }

    /*
     * Enabled aggressive block sorting
     */
    static Parser<Number> parse(Input input, StringBuilder builder, int mode, int step) {
        int c;
        block34: {
            block33: {
                block32: {
                    block35: {
                        c = 0;
                        if (step != 1) break block32;
                        if (!input.isCont()) break block35;
                        c = input.head();
                        if (c == 46) {
                            input = input.step();
                            builder.appendCodePoint(c);
                            step = 2;
                            break block32;
                        } else if (mode > 1 && (c == 69 || c == 101)) {
                            input = input.step();
                            builder.appendCodePoint(c);
                            step = 5;
                            break block32;
                        } else {
                            return Parser.error(Diagnostic.expected("decimal or exponent", input));
                        }
                    }
                    if (input.isDone()) {
                        return Parser.error(Diagnostic.expected("decimal or exponent", input));
                    }
                }
                if (step == 2) {
                    if (input.isCont()) {
                        c = input.head();
                        if (c >= 48 && c <= 57) {
                            input = input.step();
                            builder.appendCodePoint(c);
                            step = 3;
                            break block33;
                        } else {
                            return Parser.error(Diagnostic.expected("digit", input));
                        }
                    }
                    if (input.isDone()) {
                        return Parser.error(Diagnostic.expected("digit", input));
                    }
                }
            }
            if (step == 3) {
                while (input.isCont() && (c = input.head()) >= 48 && c <= 57) {
                    input = input.step();
                    builder.appendCodePoint(c);
                }
                if (input.isCont()) {
                    if (mode <= 1) {
                        String value = builder.toString();
                        return Parser.done(NumberParser.valueOf(builder.toString()));
                    }
                    step = 4;
                } else if (input.isDone()) {
                    return Parser.done(NumberParser.valueOf(builder.toString()));
                }
            }
            if (step == 4) {
                c = input.head();
                if (c != 69 && c != 101) {
                    return Parser.done(NumberParser.valueOf(builder.toString()));
                }
                input = input.step();
                builder.appendCodePoint(c);
                step = 5;
            }
            if (step == 5) {
                if (input.isCont()) {
                    c = input.head();
                    if (c == 43 || c == 45) {
                        input = input.step();
                        builder.appendCodePoint(c);
                    }
                    step = 6;
                } else if (input.isDone()) {
                    return Parser.error(Diagnostic.unexpected(input));
                }
            }
            if (step == 6) {
                if (input.isCont()) {
                    c = input.head();
                    if (c >= 48 && c <= 57) {
                        input = input.step();
                        builder.appendCodePoint(c);
                        step = 7;
                        break block34;
                    } else {
                        return Parser.error(Diagnostic.expected("digit", input));
                    }
                }
                if (input.isDone()) {
                    return Parser.error(Diagnostic.expected("digit", input));
                }
            }
        }
        if (step == 7) {
            while (input.isCont() && (c = input.head()) >= 48 && c <= 57) {
                input = input.step();
                builder.appendCodePoint(c);
            }
            if (!input.isEmpty()) {
                return Parser.done(NumberParser.valueOf(builder.toString()));
            }
        }
        if (input.isError()) {
            return Parser.error(input.trap());
        }
        return new DecimalParser(builder, mode, step);
    }

    static Parser<Number> parse(Input input, int sign, long value, int mode) {
        StringBuilder builder = new StringBuilder();
        if (sign < 0 && value == 0L) {
            builder.append('-').append('0');
        } else {
            builder.append(value);
        }
        return DecimalParser.parse(input, builder, mode, 1);
    }
}

