/*
 * Decompiled with CFR 0.152.
 */
package swim.codec;

import swim.codec.Decoder;
import swim.codec.DecoderException;
import swim.codec.InputBuffer;

final class DetectDecoder<O>
extends Decoder<O> {
    final Decoder<O>[] decoders;
    final int detectionWindow;
    final int consumed;
    static final int DETECTION_WINDOW;
    static final Decoder<Object> DETECTION_FAILED;

    DetectDecoder(Decoder<O>[] decoders, int detectionWindow, int consumed) {
        this.decoders = decoders;
        this.detectionWindow = detectionWindow;
        this.consumed = consumed;
    }

    DetectDecoder(Decoder<O>[] decoders, int detectionWindow) {
        this(decoders, detectionWindow, 0);
    }

    DetectDecoder(Decoder<O>[] decoders) {
        this(decoders, DETECTION_WINDOW, 0);
    }

    @Override
    public Decoder<O> feed(InputBuffer input) {
        return DetectDecoder.decode(input, this.decoders, this.detectionWindow, this.consumed);
    }

    static <O> Decoder<O> decode(InputBuffer input, Decoder<O>[] oldDecoders, int detectionWindow, int consumed) {
        int i;
        int n = oldDecoders.length;
        Decoder[] newDecoders = new Decoder[n];
        int firstCont = -1;
        int contCount = 0;
        int trapCount = 0;
        int inputStart = input.index();
        int inputLimit = input.limit();
        int inputRemaining = inputLimit - inputStart;
        int inputConsumed = 0;
        for (i = 0; i < n; ++i) {
            Decoder<Object> decoder = oldDecoders[i];
            input = input.index(inputStart).limit(inputLimit);
            decoder = contCount == 0 || consumed + inputConsumed < detectionWindow ? decoder.feed(input) : DETECTION_FAILED.asError();
            if (decoder.isDone() && input.isDone()) {
                return decoder;
            }
            inputConsumed = Math.max(inputConsumed, input.index() - inputStart);
            newDecoders[i] = decoder;
            if (decoder.isError()) {
                ++trapCount;
                continue;
            }
            ++contCount;
            if (firstCont != -1) continue;
            firstCont = i;
        }
        if (input.isDone()) {
            return Decoder.error(new DecoderException("unexpected end of input"));
        }
        if (input.isError()) {
            return Decoder.error(input.trap());
        }
        if (contCount == 1) {
            return newDecoders[firstCont];
        }
        if (trapCount != 0) {
            oldDecoders = newDecoders;
            newDecoders = new Decoder[contCount];
            int j = 0;
            for (i = firstCont; i < n; ++i) {
                Decoder<O> decoder = oldDecoders[i];
                if (decoder.isError()) continue;
                newDecoders[j] = decoder;
                ++j;
            }
        }
        return new DetectDecoder<O>(newDecoders, detectionWindow, consumed += inputConsumed);
    }

    static <O> Decoder<O> decode(InputBuffer input, Decoder<O>[] decoders, int detectionWindow) {
        return DetectDecoder.decode(input, decoders, detectionWindow, 0);
    }

    static <O> Decoder<O> decode(InputBuffer input, Decoder<O>[] decoders) {
        return DetectDecoder.decode(input, decoders, DETECTION_WINDOW, 0);
    }

    static {
        int detectionWindow;
        try {
            detectionWindow = Integer.parseInt(System.getProperty("swim.codec.detection.window"));
        }
        catch (NumberFormatException e) {
            detectionWindow = 128;
        }
        DETECTION_WINDOW = detectionWindow;
        DETECTION_FAILED = Decoder.error(new DecoderException("detection failed"));
    }
}

