/*
 * Decompiled with CFR 0.152.
 */
package swim.codec;

import swim.codec.Input;
import swim.codec.Parser;

final class DetectParser<O>
extends Parser<O> {
    final Parser<O>[] parsers;

    DetectParser(Parser<O>[] parsers) {
        this.parsers = parsers;
    }

    @Override
    public Parser<O> feed(Input input) {
        return DetectParser.parse(input, this.parsers);
    }

    static <O> Parser<O> parse(Input input, Parser<O>[] oldParsers) {
        int i;
        int n = oldParsers.length;
        Parser[] newParsers = new Parser[n];
        int firstCont = -1;
        int contCount = 0;
        int trapCount = 0;
        for (i = 0; i < n; ++i) {
            Parser<O> parser = oldParsers[i];
            Input parserInput = input.clone();
            if ((parser = parser.feed(parserInput)).isDone() && parserInput.isDone()) {
                return parser;
            }
            newParsers[i] = parser;
            if (parser.isError()) {
                ++trapCount;
                continue;
            }
            ++contCount;
            if (firstCont != -1) continue;
            firstCont = i;
        }
        if (input.isError()) {
            return Parser.error(input.trap());
        }
        if (contCount == 1) {
            return newParsers[firstCont];
        }
        if (trapCount != 0) {
            oldParsers = newParsers;
            newParsers = new Parser[contCount];
            int j = 0;
            for (i = firstCont; i < n; ++i) {
                Parser<O> parser = oldParsers[i];
                if (parser.isError()) continue;
                newParsers[j] = parser;
                ++j;
            }
        }
        return new DetectParser<O>(newParsers);
    }
}

