/*
 * Decompiled with CFR 0.152.
 */
package swim.codec;

import swim.codec.Output;
import swim.codec.OutputException;
import swim.codec.OutputSettings;

final class OutputFull<T>
extends Output<T> {
    final T value;
    final OutputSettings settings;

    OutputFull(T value, OutputSettings settings) {
        this.value = value;
        this.settings = settings;
    }

    @Override
    public boolean isCont() {
        return false;
    }

    @Override
    public boolean isFull() {
        return true;
    }

    @Override
    public boolean isDone() {
        return false;
    }

    @Override
    public boolean isError() {
        return false;
    }

    @Override
    public boolean isPart() {
        return true;
    }

    @Override
    public Output<T> isPart(boolean isPart) {
        if (isPart) {
            return Output.done(this.value, this.settings);
        }
        return this;
    }

    @Override
    public Output<T> write(int token) {
        return Output.error(new OutputException("full"), this.settings);
    }

    @Override
    public Output<T> write(String string) {
        return Output.error(new OutputException("full"), this.settings);
    }

    @Override
    public Output<T> writeln(String string) {
        return Output.error(new OutputException("full"), this.settings);
    }

    @Override
    public Output<T> writeln() {
        return Output.error(new OutputException("full"), this.settings);
    }

    @Override
    public T bind() {
        return this.value;
    }

    @Override
    public OutputSettings settings() {
        return this.settings;
    }

    @Override
    public Output<T> settings(OutputSettings settings) {
        return Output.full(this.value, settings);
    }

    @Override
    public Output<T> clone() {
        return this;
    }
}

