/*
 * Decompiled with CFR 0.152.
 */
package swim.codec;

import swim.codec.Input;
import swim.codec.Output;
import swim.codec.Parser;

final class OutputParser<O>
extends Parser<O> {
    final Input input;
    final Output<O> output;

    OutputParser(Input input, Output<O> output) {
        this.input = input;
        this.output = output;
    }

    @Override
    public Parser<O> feed(Input input) {
        if (this.input != null) {
            input = this.input.fork(input);
        }
        return OutputParser.parse(input, this.output);
    }

    static <O> Parser<O> parse(Input input, Output<O> output) {
        while (input.isCont()) {
            output = output.write(input.head());
            input = input.step();
        }
        if (input.isDone()) {
            return Parser.done(output.bind());
        }
        if (input.isError()) {
            return Parser.error(input.trap());
        }
        if (output.isError()) {
            return Parser.error(output.trap());
        }
        return new OutputParser<O>(input, output);
    }
}

