/*
 * Decompiled with CFR 0.152.
 */
package swim.codec;

import swim.codec.Debug;
import swim.codec.Format;
import swim.codec.Output;
import swim.codec.UtfFatalErrorMode;
import swim.codec.UtfReplacementErrorMode;

public abstract class UtfErrorMode
implements Debug {
    private static UtfErrorMode fatal;
    private static UtfErrorMode fatalNonZero;
    private static UtfErrorMode replacement;
    private static UtfErrorMode replacementNonZero;

    UtfErrorMode() {
    }

    public boolean isFatal() {
        return false;
    }

    public boolean isReplacement() {
        return false;
    }

    public int replacementChar() {
        return 65533;
    }

    public abstract boolean isNonZero();

    public abstract UtfErrorMode isNonZero(boolean var1);

    @Override
    public abstract <T> Output<T> debug(Output<T> var1);

    public String toString() {
        return Format.debug(this);
    }

    public static UtfErrorMode fatal() {
        if (fatal == null) {
            fatal = new UtfFatalErrorMode(false);
        }
        return fatal;
    }

    public static UtfErrorMode fatalNonZero() {
        if (fatalNonZero == null) {
            fatalNonZero = new UtfFatalErrorMode(true);
        }
        return fatalNonZero;
    }

    public static UtfErrorMode replacement() {
        if (replacement == null) {
            replacement = new UtfReplacementErrorMode(65533, false);
        }
        return replacement;
    }

    public static UtfErrorMode replacement(int replacementChar) {
        if (replacementChar == 65533) {
            return UtfErrorMode.replacement();
        }
        return new UtfReplacementErrorMode(replacementChar, false);
    }

    public static UtfErrorMode replacementNonZero() {
        if (replacementNonZero == null) {
            replacementNonZero = new UtfReplacementErrorMode(65533, true);
        }
        return replacementNonZero;
    }

    public static UtfErrorMode replacementNonZero(int replacementChar) {
        if (replacementChar == 65533) {
            return UtfErrorMode.replacementNonZero();
        }
        return new UtfReplacementErrorMode(replacementChar, true);
    }
}

