/*
 * Decompiled with CFR 0.152.
 */
package swim.collections;

import java.util.Comparator;
import java.util.Map;
import swim.codec.Debug;
import swim.codec.Format;
import swim.codec.Output;
import swim.collections.BTreeContext;
import swim.collections.BTreePage;
import swim.util.Cursor;
import swim.util.OrderedMap;
import swim.util.OrderedMapCursor;

public class BTree<K, V>
extends BTreeContext<K, V>
implements OrderedMap<K, V>,
Debug {
    private static BTree<Object, Object> empty;
    final BTreePage<K, V, ?> root;

    protected BTree(BTreePage<K, V, ?> root) {
        this.root = root;
    }

    public static <K, V> BTree<K, V> empty() {
        if (empty == null) {
            empty = new BTree(BTreePage.empty());
        }
        return empty;
    }

    public static <K, V> BTree<K, V> of(K key, V value) {
        BTree<K, V> tree = BTree.empty();
        tree = tree.updated(key, value);
        return tree;
    }

    public static <K, V> BTree<K, V> from(Map<? extends K, ? extends V> map) {
        BTree<K, V> tree = BTree.empty();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            tree = tree.updated(entry.getKey(), entry.getValue());
        }
        return tree;
    }

    public boolean isEmpty() {
        return this.root.isEmpty();
    }

    public int size() {
        return this.root.size();
    }

    public boolean containsKey(Object key) {
        return this.root.containsKey(key, this);
    }

    public boolean containsValue(Object value) {
        return this.root.containsValue(value);
    }

    public int indexOf(Object key) {
        return this.root.indexOf(key, this);
    }

    public V get(Object key) {
        return this.root.get(key, this);
    }

    public Map.Entry<K, V> getEntry(Object key) {
        return this.root.getEntry(key, this);
    }

    public Map.Entry<K, V> getIndex(int index) {
        return this.root.getIndex(index);
    }

    public Map.Entry<K, V> firstEntry() {
        return this.root.firstEntry();
    }

    public K firstKey() {
        Map.Entry<K, V> entry = this.root.firstEntry();
        if (entry != null) {
            return entry.getKey();
        }
        return null;
    }

    public V firstValue() {
        Map.Entry<K, V> entry = this.root.firstEntry();
        if (entry != null) {
            return entry.getValue();
        }
        return null;
    }

    public Map.Entry<K, V> lastEntry() {
        return this.root.lastEntry();
    }

    public K lastKey() {
        Map.Entry<K, V> entry = this.root.lastEntry();
        if (entry != null) {
            return entry.getKey();
        }
        return null;
    }

    public V lastValue() {
        Map.Entry<K, V> entry = this.root.lastEntry();
        if (entry != null) {
            return entry.getValue();
        }
        return null;
    }

    public Map.Entry<K, V> nextEntry(K key) {
        return this.root.nextEntry(key, this);
    }

    public K nextKey(K key) {
        Map.Entry<K, V> entry = this.root.nextEntry(key, this);
        if (entry != null) {
            return entry.getKey();
        }
        return null;
    }

    public V nextValue(K key) {
        Map.Entry<K, V> entry = this.root.nextEntry(key, this);
        if (entry != null) {
            return entry.getValue();
        }
        return null;
    }

    public Map.Entry<K, V> previousEntry(K key) {
        return this.root.previousEntry(key, this);
    }

    public K previousKey(K key) {
        Map.Entry<K, V> entry = this.root.previousEntry(key, this);
        if (entry != null) {
            return entry.getKey();
        }
        return null;
    }

    public V previousValue(K key) {
        Map.Entry<K, V> entry = this.root.previousEntry(key, this);
        if (entry != null) {
            return entry.getValue();
        }
        return null;
    }

    public V put(K key, V newValue) {
        throw new UnsupportedOperationException();
    }

    public void putAll(Map<? extends K, ? extends V> map) {
        throw new UnsupportedOperationException();
    }

    public V remove(Object key) {
        throw new UnsupportedOperationException();
    }

    public BTree<K, V> drop(int lower) {
        if (lower > 0 && this.root.size() > 0) {
            if (lower < this.root.size()) {
                return this.copy(this.root.drop(lower, this).balanced(this));
            }
            return BTree.empty();
        }
        return this;
    }

    public BTree<K, V> take(int upper) {
        if (upper < this.root.size() && this.root.size() > 0) {
            if (upper > 0) {
                return this.copy(this.root.take(upper, this).balanced(this));
            }
            return BTree.empty();
        }
        return this;
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public BTree<K, V> updated(K key, V newValue) {
        BTreePage<K, V, ?> oldRoot = this.root;
        BTreePage<K, V, ?> newRoot = oldRoot.updated(key, newValue, this);
        if (oldRoot != newRoot) {
            if (newRoot.size() > oldRoot.size()) {
                newRoot = newRoot.balanced(this);
            }
            return this.copy(newRoot);
        }
        return this;
    }

    public BTree<K, V> removed(K key) {
        BTreePage<K, V, ?> oldRoot = this.root;
        BTreePage<K, V, ?> newRoot = oldRoot.removed(key, this).balanced(this);
        if (oldRoot != newRoot) {
            return this.copy(newRoot);
        }
        return this;
    }

    public BTree<K, V> cleared() {
        return BTree.empty();
    }

    public OrderedMapCursor<K, V> iterator() {
        return this.root.iterator();
    }

    public Cursor<K> keyIterator() {
        return this.root.keyIterator();
    }

    public Cursor<V> valueIterator() {
        return this.root.valueIterator();
    }

    public OrderedMapCursor<K, V> lastIterator() {
        return this.root.lastIterator();
    }

    public Cursor<K> lastKeyIterator() {
        return this.root.lastKeyIterator();
    }

    public Cursor<V> lastValueIterator() {
        return this.root.lastValueIterator();
    }

    protected BTree<K, V> copy(BTreePage<K, V, ?> root) {
        return new BTree<K, V>(root);
    }

    public Comparator<? super K> comparator() {
        return null;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof Map) {
            Map that = (Map)other;
            if (this.size() == that.size()) {
                for (Map.Entry entry : that.entrySet()) {
                    V value = this.get(entry.getKey());
                    Object v = entry.getValue();
                    if (!(value == null ? v != null : !value.equals(v))) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int code = 0;
        OrderedMapCursor<K, V> these = this.iterator();
        while (these.hasNext()) {
            code += ((Map.Entry)these.next()).hashCode();
        }
        return code;
    }

    public void debug(Output<?> output) {
        output = output.write("BTree").write(46);
        OrderedMapCursor<K, V> these = this.iterator();
        if (these.hasNext()) {
            Map.Entry entry = (Map.Entry)these.next();
            output = output.write("of").write(40).debug(entry.getKey()).write(", ").debug(entry.getValue());
            while (these.hasNext()) {
                entry = (Map.Entry)these.next();
                output = output.write(41).write(46).write("updated").write(40).debug(entry.getKey()).write(", ").debug(entry.getValue());
            }
        } else {
            output = output.write("empty").write(40);
        }
        output = output.write(41);
    }

    public String toString() {
        return Format.debug((Object)this);
    }
}

