/*
 * Decompiled with CFR 0.152.
 */
package swim.collections;

import java.util.Map;
import swim.collections.BTreeContext;
import swim.collections.BTreeLeaf;
import swim.util.CombinerFunction;
import swim.util.Cursor;
import swim.util.OrderedMapCursor;

public abstract class BTreePage<K, V, U> {
    BTreePage() {
    }

    public static <K, V, U> BTreePage<K, V, U> empty() {
        return BTreeLeaf.empty();
    }

    public abstract boolean isEmpty();

    public abstract int size();

    public abstract int arity();

    public abstract U fold();

    public abstract K minKey();

    public abstract K maxKey();

    public abstract boolean containsKey(Object var1, BTreeContext<K, V> var2);

    public abstract boolean containsValue(Object var1);

    public abstract int indexOf(Object var1, BTreeContext<K, V> var2);

    public abstract V get(Object var1, BTreeContext<K, V> var2);

    public abstract Map.Entry<K, V> getEntry(Object var1, BTreeContext<K, V> var2);

    public abstract Map.Entry<K, V> getIndex(int var1);

    public abstract Map.Entry<K, V> firstEntry();

    public abstract Map.Entry<K, V> lastEntry();

    public abstract Map.Entry<K, V> nextEntry(K var1, BTreeContext<K, V> var2);

    public abstract Map.Entry<K, V> previousEntry(K var1, BTreeContext<K, V> var2);

    public abstract BTreePage<K, V, U> updated(K var1, V var2, BTreeContext<K, V> var3);

    public abstract BTreePage<K, V, U> removed(Object var1, BTreeContext<K, V> var2);

    public abstract BTreePage<K, V, U> drop(int var1, BTreeContext<K, V> var2);

    public abstract BTreePage<K, V, U> take(int var1, BTreeContext<K, V> var2);

    public abstract BTreePage<K, V, U> balanced(BTreeContext<K, V> var1);

    public abstract BTreePage<K, V, U> split(int var1);

    public abstract BTreePage<K, V, U> splitLeft(int var1);

    public abstract BTreePage<K, V, U> splitRight(int var1);

    public abstract BTreePage<K, V, U> reduced(U var1, CombinerFunction<? super V, U> var2, CombinerFunction<U, U> var3);

    public Cursor<K> keyIterator() {
        return Cursor.keys(this.iterator());
    }

    public Cursor<V> valueIterator() {
        return Cursor.values(this.iterator());
    }

    public abstract OrderedMapCursor<K, V> iterator();

    public Cursor<K> lastKeyIterator() {
        return Cursor.keys(this.lastIterator());
    }

    public Cursor<V> lastValueIterator() {
        return Cursor.values(this.lastIterator());
    }

    public abstract OrderedMapCursor<K, V> lastIterator();
}

