/*
 * Decompiled with CFR 0.152.
 */
package swim.collections;

import java.util.AbstractMap;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import swim.codec.Debug;
import swim.codec.Format;
import swim.codec.Output;
import swim.collections.ArrayMap;
import swim.collections.HashTrieMapEntryIterator;
import swim.collections.HashTrieMapEntrySet;
import swim.collections.HashTrieMapKeyIterator;
import swim.collections.HashTrieMapKeySet;
import swim.collections.HashTrieMapValueIterator;
import swim.collections.HashTrieMapValues;
import swim.collections.HashTrieSet;
import swim.util.Murmur3;

public final class HashTrieMap<K, V>
implements Iterable<Map.Entry<K, V>>,
Map<K, V>,
Debug {
    static final int VOID = 0;
    static final int LEAF = 1;
    static final int TREE = 2;
    static final int KNOT = 3;
    private static int hashSeed;
    private static HashTrieMap<Object, Object> empty;
    final int treeMap;
    final int leafMap;
    final Object[] slots;

    HashTrieMap(int treeMap, int leafMap, Object[] slots) {
        this.treeMap = treeMap;
        this.leafMap = leafMap;
        this.slots = slots;
    }

    static boolean containsKey(HashTrieMap<?, ?> tree, Object key, int keyHash, int shift) {
        block6: while (true) {
            int branch = tree.choose(keyHash, shift);
            switch (tree.follow(branch)) {
                case 0: {
                    return false;
                }
                case 1: {
                    return key.equals(tree.getKey(branch));
                }
                case 2: {
                    tree = tree.getTree(branch);
                    shift += 5;
                    continue block6;
                }
                case 3: {
                    return tree.getKnot(branch).containsKey(key);
                }
            }
            break;
        }
        throw new AssertionError();
    }

    static <K, V> Map.Entry<K, V> head(HashTrieMap<K, V> tree) {
        block6: while (true) {
            int treeMap = tree.treeMap;
            int leafMap = tree.leafMap;
            while ((treeMap | leafMap) != 0) {
                switch (leafMap & 1 | (treeMap & 1) << 1) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        return new AbstractMap.SimpleImmutableEntry<K, V>(tree.keyAt(0), tree.valueAt(0));
                    }
                    case 2: {
                        tree = tree.treeAt(0);
                        continue block6;
                    }
                    case 3: {
                        return tree.knotAt(0).head();
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
                treeMap >>>= 1;
                leafMap >>>= 1;
            }
            break;
        }
        return null;
    }

    static <K> K headKey(HashTrieMap<K, ?> tree) {
        block6: while (true) {
            int treeMap = tree.treeMap;
            int leafMap = tree.leafMap;
            while ((treeMap | leafMap) != 0) {
                switch (leafMap & 1 | (treeMap & 1) << 1) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        return tree.keyAt(0);
                    }
                    case 2: {
                        tree = tree.treeAt(0);
                        continue block6;
                    }
                    case 3: {
                        return tree.knotAt(0).headKey();
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
                treeMap >>>= 1;
                leafMap >>>= 1;
            }
            break;
        }
        return null;
    }

    static <V> V headValue(HashTrieMap<?, V> tree) {
        block6: while (true) {
            int treeMap = tree.treeMap;
            int leafMap = tree.leafMap;
            while ((treeMap | leafMap) != 0) {
                switch (leafMap & 1 | (treeMap & 1) << 1) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        return tree.valueAt(0);
                    }
                    case 2: {
                        tree = tree.treeAt(0);
                        continue block6;
                    }
                    case 3: {
                        return tree.knotAt(0).headValue();
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
                treeMap >>>= 1;
                leafMap >>>= 1;
            }
            break;
        }
        return null;
    }

    static <V> V get(HashTrieMap<?, V> tree, Object key, int keyHash, int shift) {
        block6: while (true) {
            int branch = tree.choose(keyHash, shift);
            switch (tree.follow(branch)) {
                case 0: {
                    return null;
                }
                case 1: {
                    if (key.equals(tree.getKey(branch))) {
                        return tree.getValue(branch);
                    }
                    return null;
                }
                case 2: {
                    tree = tree.getTree(branch);
                    shift += 5;
                    continue block6;
                }
                case 3: {
                    return tree.getKnot(branch).get(key);
                }
            }
            break;
        }
        throw new AssertionError();
    }

    public static <K, V> HashTrieMap<K, V> empty() {
        if (empty == null) {
            empty = new HashTrieMap<K, V>(0, 0, new Object[0]);
        }
        return empty;
    }

    public static <K, V> HashTrieMap<K, V> of(K key, V value) {
        return HashTrieMap.empty().updated(key, value);
    }

    public static <K, V> HashTrieMap<K, V> from(Map<? extends K, ? extends V> map) {
        HashTrieMap<K, V> trie = HashTrieMap.empty();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            trie = trie.updated(entry.getKey(), entry.getValue());
        }
        return trie;
    }

    public static <K, V> HashTrieMap<K, HashTrieSet<V>> updated(HashTrieMap<K, HashTrieSet<V>> multimap, K key, V value) {
        HashTrieSet<Object> set = multimap.get(key);
        if (set == null) {
            set = HashTrieSet.empty();
        }
        set = set.added(value);
        multimap = multimap.updated(key, set);
        return multimap;
    }

    public static <K, V> HashTrieMap<K, HashTrieSet<V>> merged(HashTrieMap<K, HashTrieSet<V>> multimap, HashTrieMap<K, HashTrieSet<V>> that) {
        for (Map.Entry<K, HashTrieSet<V>> entry : that) {
            HashTrieSet<HashTrieSet<V>> these = multimap.get(entry.getKey());
            these = these != null ? these.merged(entry.getValue()) : entry.getValue();
            multimap = multimap.updated(entry.getKey(), these);
        }
        return multimap;
    }

    public static <K, V> HashTrieMap<K, HashTrieSet<V>> removed(HashTrieMap<K, HashTrieSet<V>> multimap, K key, V value) {
        HashTrieSet<V> set = multimap.get(key);
        if (set == null) {
            return multimap;
        }
        multimap = (set = set.removed(value)).isEmpty() ? multimap.removed(key) : multimap.updated(key, set);
        return multimap;
    }

    @Override
    public boolean isEmpty() {
        return this.slotMap() == 0;
    }

    @Override
    public int size() {
        int t = 0;
        int i = 0;
        int treeMap = this.treeMap;
        int leafMap = this.leafMap;
        while ((treeMap | leafMap) != 0) {
            switch (leafMap & 1 | (treeMap & 1) << 1) {
                case 0: {
                    break;
                }
                case 1: {
                    ++t;
                    ++i;
                    break;
                }
                case 2: {
                    t += this.treeAt(i).size();
                    ++i;
                    break;
                }
                case 3: {
                    t += this.knotAt(i).size();
                    ++i;
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            treeMap >>>= 1;
            leafMap >>>= 1;
        }
        return t;
    }

    @Override
    public boolean containsKey(Object key) {
        if (key != null) {
            return HashTrieMap.containsKey(this, key, Murmur3.hash((Object)key), 0);
        }
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        int i = 0;
        int j = 0;
        int treeMap = this.treeMap;
        int leafMap = this.leafMap;
        while ((treeMap | leafMap) != 0) {
            switch (leafMap & 1 | (treeMap & 1) << 1) {
                case 0: {
                    break;
                }
                case 1: {
                    V v = this.valueAt(j);
                    if (value == null ? v == null : value.equals(v)) {
                        return true;
                    }
                    ++i;
                    ++j;
                    break;
                }
                case 2: {
                    if (this.treeAt(i).containsValue(value)) {
                        return true;
                    }
                    ++i;
                    break;
                }
                case 3: {
                    if (this.knotAt(i).containsValue(value)) {
                        return true;
                    }
                    ++i;
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            treeMap >>>= 1;
            leafMap >>>= 1;
        }
        return false;
    }

    public Map.Entry<K, V> head() {
        return HashTrieMap.head(this);
    }

    public K headKey() {
        return HashTrieMap.headKey(this);
    }

    public V headValue() {
        return HashTrieMap.headValue(this);
    }

    public Map.Entry<K, V> next(Object key) {
        Map.Entry<K, V> next = this.next(key, Murmur3.hash((Object)key), 0);
        if (next == null) {
            next = HashTrieMap.head(this);
        }
        return next;
    }

    public K nextKey(Object key) {
        K next = this.nextKey(key, Murmur3.hash((Object)key), 0);
        if (next == null) {
            next = HashTrieMap.headKey(this);
        }
        return next;
    }

    public V nextValue(Object key) {
        V next = this.nextValue(key, Murmur3.hash((Object)key), 0);
        if (next == null) {
            next = HashTrieMap.headValue(this);
        }
        return next;
    }

    @Override
    public V get(Object key) {
        if (key != null) {
            return HashTrieMap.get(this, key, Murmur3.hash((Object)key), 0);
        }
        return null;
    }

    @Override
    public V put(K key, V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    public HashTrieMap<K, V> updated(K key, V value) {
        if (key != null) {
            return this.updated(key, Murmur3.hash(key), value, 0);
        }
        throw new NullPointerException();
    }

    public HashTrieMap<K, V> updated(Map<? extends K, ? extends V> map) {
        HashTrieMap<K, V> these = this;
        for (Map.Entry<K, V> entry : map.entrySet()) {
            these = these.updated(entry.getKey(), entry.getValue());
        }
        return these;
    }

    public HashTrieMap<K, V> removed(Object key) {
        if (key != null) {
            return this.removed(key, Murmur3.hash((Object)key), 0);
        }
        return this;
    }

    int slotMap() {
        return this.treeMap | this.leafMap;
    }

    int choose(int hash, int shift) {
        return 1 << (hash >>> shift & 0x1F);
    }

    int select(int branch) {
        return Integer.bitCount(this.slotMap() & branch - 1);
    }

    int lookup(int branch) {
        return Integer.bitCount(this.leafMap & branch - 1);
    }

    int follow(int branch) {
        return ((this.leafMap & branch) != 0 ? 1 : 0) | ((this.treeMap & branch) != 0 ? 2 : 0);
    }

    K keyAt(int index) {
        return (K)this.slots[index];
    }

    K getKey(int branch) {
        return (K)this.slots[this.select(branch)];
    }

    V valueAt(int index) {
        return (V)this.slots[this.slots.length - index - 1];
    }

    V getValue(int branch) {
        return (V)this.slots[this.slots.length - this.lookup(branch) - 1];
    }

    HashTrieMap<K, V> setLeaf(int branch, K key, V value) {
        this.slots[this.select((int)branch)] = key;
        this.slots[this.slots.length - this.lookup((int)branch) - 1] = value;
        return this;
    }

    HashTrieMap<K, V> treeAt(int index) {
        return (HashTrieMap)this.slots[index];
    }

    HashTrieMap<K, V> getTree(int branch) {
        return (HashTrieMap)this.slots[this.select(branch)];
    }

    HashTrieMap<K, V> setTree(int branch, HashTrieMap<K, V> tree) {
        this.slots[this.select((int)branch)] = tree;
        return this;
    }

    ArrayMap<K, V> knotAt(int index) {
        return (ArrayMap)this.slots[index];
    }

    ArrayMap<K, V> getKnot(int branch) {
        return (ArrayMap)this.slots[this.select(branch)];
    }

    HashTrieMap<K, V> setKnot(int branch, ArrayMap<K, V> knot) {
        this.slots[this.select((int)branch)] = knot;
        return this;
    }

    boolean isUnary() {
        return this.treeMap == 0 && Integer.bitCount(this.leafMap) == 1;
    }

    K unaryKey() {
        return (K)this.slots[0];
    }

    V unaryValue() {
        return (V)this.slots[1];
    }

    HashTrieMap<K, V> remap(int treeMap, int leafMap) {
        int newSlotMap;
        int oldLeafMap = this.leafMap;
        int newLeafMap = leafMap;
        int oldSlotMap = this.treeMap | this.leafMap;
        if (oldLeafMap == newLeafMap && oldSlotMap == newSlotMap) {
            return new HashTrieMap<K, V>(treeMap, leafMap, (Object[])this.slots.clone());
        }
        int i = 0;
        int j = 0;
        Object[] newSlots = new Object[Integer.bitCount(newSlotMap) + Integer.bitCount(newLeafMap)];
        for (newSlotMap = treeMap | leafMap; newSlotMap != 0; newSlotMap >>>= 1) {
            if ((oldSlotMap & newSlotMap & 1) == 1) {
                newSlots[j] = this.slots[i];
            }
            if ((oldSlotMap & 1) == 1) {
                ++i;
            }
            if ((newSlotMap & 1) == 1) {
                ++j;
            }
            oldSlotMap >>>= 1;
        }
        i = this.slots.length - 1;
        j = newSlots.length - 1;
        while (newLeafMap != 0) {
            if ((oldLeafMap & newLeafMap & 1) == 1) {
                newSlots[j] = this.slots[i];
            }
            if ((oldLeafMap & 1) == 1) {
                --i;
            }
            if ((newLeafMap & 1) == 1) {
                --j;
            }
            oldLeafMap >>>= 1;
            newLeafMap >>>= 1;
        }
        return new HashTrieMap<K, V>(treeMap, leafMap, newSlots);
    }

    Map.Entry<K, V> next(Object key, int keyHash, int shift) {
        int block = key == null ? 0 : keyHash >>> shift & 0x1F;
        int branch = 1 << block;
        int treeMap = this.treeMap >>> block;
        int leafMap = this.leafMap >>> block;
        while ((treeMap | leafMap) != 0) {
            switch (leafMap & 1 | (treeMap & 1) << 1) {
                case 0: {
                    break;
                }
                case 1: {
                    if (key != null) break;
                    return new AbstractMap.SimpleImmutableEntry<K, V>(this.getKey(branch), this.getValue(branch));
                }
                case 2: {
                    Map.Entry<K, V> next = this.getTree(branch).next(key, keyHash, shift + 5);
                    if (next == null) break;
                    return next;
                }
                case 3: {
                    Map.Entry<K, V> next = this.getKnot(branch).next(key);
                    if (next == null) break;
                    return next;
                }
                default: {
                    throw new AssertionError();
                }
            }
            key = null;
            keyHash = 0;
            treeMap >>>= 1;
            leafMap >>>= 1;
            branch <<= 1;
        }
        return null;
    }

    K nextKey(Object key, int keyHash, int shift) {
        int block = key == null ? 0 : keyHash >>> shift & 0x1F;
        int branch = 1 << block;
        int treeMap = this.treeMap >>> block;
        int leafMap = this.leafMap >>> block;
        while ((treeMap | leafMap) != 0) {
            switch (leafMap & 1 | (treeMap & 1) << 1) {
                case 0: {
                    break;
                }
                case 1: {
                    if (key != null) break;
                    return this.getKey(branch);
                }
                case 2: {
                    K next = this.getTree(branch).nextKey(key, keyHash, shift + 5);
                    if (next == null) break;
                    return next;
                }
                case 3: {
                    K next = this.getKnot(branch).nextKey(key);
                    if (next == null) break;
                    return next;
                }
                default: {
                    throw new AssertionError();
                }
            }
            key = null;
            keyHash = 0;
            treeMap >>>= 1;
            leafMap >>>= 1;
            branch <<= 1;
        }
        return null;
    }

    V nextValue(Object key, int keyHash, int shift) {
        int block = key == null ? 0 : keyHash >>> shift & 0x1F;
        int branch = 1 << block;
        int treeMap = this.treeMap >>> block;
        int leafMap = this.leafMap >>> block;
        while ((treeMap | leafMap) != 0) {
            switch (leafMap & 1 | (treeMap & 1) << 1) {
                case 0: {
                    break;
                }
                case 1: {
                    if (key != null) break;
                    return this.getValue(branch);
                }
                case 2: {
                    V next = this.getTree(branch).nextValue(key, keyHash, shift + 5);
                    if (next == null) break;
                    return next;
                }
                case 3: {
                    V next = this.getKnot(branch).nextValue(key);
                    if (next == null) break;
                    return next;
                }
                default: {
                    throw new AssertionError();
                }
            }
            key = null;
            keyHash = 0;
            treeMap >>>= 1;
            leafMap >>>= 1;
            branch <<= 1;
        }
        return null;
    }

    HashTrieMap<K, V> updated(K key, int keyHash, V value, int shift) {
        int branch = this.choose(keyHash, shift);
        switch (this.follow(branch)) {
            case 0: {
                return this.remap(this.treeMap, this.leafMap | branch).setLeaf(branch, key, value);
            }
            case 1: {
                K leaf = this.getKey(branch);
                int leafHash = Murmur3.hash(leaf);
                if (keyHash == leafHash && key.equals(leaf)) {
                    V v = this.getValue(branch);
                    if (value == v) {
                        return this;
                    }
                    return this.remap(this.treeMap, this.leafMap).setLeaf(branch, key, value);
                }
                if (keyHash != leafHash) {
                    return this.remap(this.treeMap | branch, this.leafMap ^ branch).setTree(branch, this.merge(leaf, leafHash, this.getValue(branch), key, keyHash, value, shift + 5));
                }
                return this.remap(this.treeMap | branch, this.leafMap).setKnot(branch, new ArrayMap<K, V>(leaf, this.getValue(branch), key, value));
            }
            case 2: {
                HashTrieMap<K, V> oldTree = this.getTree(branch);
                HashTrieMap<K, V> newTree = oldTree.updated(key, keyHash, value, shift + 5);
                if (oldTree == newTree) {
                    return this;
                }
                return this.remap(this.treeMap, this.leafMap).setTree(branch, newTree);
            }
            case 3: {
                ArrayMap<K, V> oldKnot = this.getKnot(branch);
                ArrayMap<K, V> newKnot = oldKnot.updated(key, value);
                if (oldKnot == newKnot) {
                    return this;
                }
                return this.remap(this.treeMap, this.leafMap).setKnot(branch, newKnot);
            }
        }
        throw new AssertionError();
    }

    HashTrieMap<K, V> merge(K key0, int hash0, V value0, K key1, int hash1, V value1, int shift) {
        int branch0 = this.choose(hash0, shift);
        int branch1 = this.choose(hash1, shift);
        int slotMap = branch0 | branch1;
        if (branch0 == branch1) {
            Object[] slots = new Object[]{this.merge(key0, hash0, value0, key1, hash1, value1, shift + 5)};
            return new HashTrieMap<K, V>(slotMap, 0, slots);
        }
        Object[] slots = new Object[4];
        if ((branch0 - 1 & branch1) == 0) {
            slots[0] = key0;
            slots[1] = key1;
            slots[2] = value1;
            slots[3] = value0;
        } else {
            slots[0] = key1;
            slots[1] = key0;
            slots[2] = value0;
            slots[3] = value1;
        }
        return new HashTrieMap<K, V>(0, slotMap, slots);
    }

    HashTrieMap<K, V> removed(Object key, int keyHash, int shift) {
        int branch = this.choose(keyHash, shift);
        switch (this.follow(branch)) {
            case 0: {
                return this;
            }
            case 1: {
                if (!key.equals(this.getKey(branch))) {
                    return this;
                }
                return this.remap(this.treeMap, this.leafMap ^ branch);
            }
            case 2: {
                HashTrieMap<K, V> oldTree = this.getTree(branch);
                HashTrieMap<K, V> newTree = oldTree.removed(key, keyHash, shift + 5);
                if (oldTree == newTree) {
                    return this;
                }
                if (newTree.isEmpty()) {
                    return this.remap(this.treeMap ^ branch, this.leafMap);
                }
                if (newTree.isUnary()) {
                    return this.remap(this.treeMap ^ branch, this.leafMap | branch).setLeaf(branch, newTree.unaryKey(), newTree.unaryValue());
                }
                return this.remap(this.treeMap, this.leafMap).setTree(branch, newTree);
            }
            case 3: {
                ArrayMap<K, V> oldKnot = this.getKnot(branch);
                ArrayMap<K, V> newKnot = oldKnot.removed(key);
                if (oldKnot == newKnot) {
                    return this;
                }
                if (newKnot.isEmpty()) {
                    return this.remap(this.treeMap ^ branch, this.leafMap);
                }
                if (newKnot.isUnary()) {
                    return this.remap(this.treeMap ^ branch, this.leafMap | branch).setLeaf(branch, newKnot.unaryKey(), newKnot.unaryValue());
                }
                return this.remap(this.treeMap, this.leafMap).setKnot(branch, newKnot);
            }
        }
        throw new AssertionError();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new HashTrieMapEntrySet(this);
    }

    @Override
    public Set<K> keySet() {
        return new HashTrieMapKeySet(this);
    }

    @Override
    public Collection<V> values() {
        return new HashTrieMapValues(this);
    }

    @Override
    public Iterator<Map.Entry<K, V>> iterator() {
        return new HashTrieMapEntryIterator(this);
    }

    public Iterator<K> keyIterator() {
        return new HashTrieMapKeyIterator(this);
    }

    public Iterator<V> valueIterator() {
        return new HashTrieMapValueIterator(this);
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof HashTrieMap) {
            HashTrieMap that = (HashTrieMap)other;
            if (this.size() == that.size()) {
                for (Map.Entry<K, V> entry : that) {
                    V value = this.get(entry.getKey());
                    V v = entry.getValue();
                    if (!(value == null ? v != null : !value.equals(v))) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(HashTrieMap.class);
        }
        int a = 0;
        int b = 0;
        int c = 1;
        for (Map.Entry<K, V> entry : this) {
            int h = Murmur3.mix((int)Murmur3.hash(entry.getKey()), (int)Murmur3.hash(entry.getValue()));
            a ^= h;
            b += h;
            if (h == 0) continue;
            c *= h;
        }
        return Murmur3.mash((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)hashSeed, (int)a), (int)b), (int)c));
    }

    public void debug(Output<?> output) {
        output = output.write("HashTrieMap").write(46);
        Iterator<Map.Entry<K, V>> these = this.iterator();
        if (these.hasNext()) {
            Map.Entry<K, V> entry = these.next();
            output = output.write("of").write(40).debug(entry.getKey()).write(", ").debug(entry.getValue());
            while (these.hasNext()) {
                entry = these.next();
                output = output.write(41).write(46).write("updated").write(40).debug(entry.getKey()).write(", ").debug(entry.getValue());
            }
        } else {
            output = output.write("empty").write(40);
        }
        output = output.write(41);
    }

    public String toString() {
        return Format.debug((Object)this);
    }
}

