/*
 * Decompiled with CFR 0.152.
 */
package swim.collections;

import java.util.AbstractMap;
import java.util.Map;
import swim.collections.STreeContext;
import swim.collections.STreeNode;
import swim.collections.STreePage;
import swim.util.Cursor;

final class STreeLeaf<T>
extends STreePage<T> {
    private static STreeLeaf<Object> empty;
    final Map.Entry<Object, T>[] slots;

    STreeLeaf(Map.Entry<Object, T>[] slots) {
        this.slots = slots;
    }

    public static <T> STreeLeaf<T> empty() {
        if (empty == null) {
            empty = new STreeLeaf<T>(new Map.Entry[0]);
        }
        return empty;
    }

    @Override
    public boolean isEmpty() {
        return this.slots.length == 0;
    }

    @Override
    public int size() {
        return this.slots.length;
    }

    @Override
    public int arity() {
        return this.slots.length;
    }

    @Override
    public boolean contains(Object value) {
        Map.Entry<Object, T>[] slots = this.slots;
        int n = slots.length;
        for (int i = 0; i < n; ++i) {
            if (!value.equals(slots[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public int indexOf(Object value) {
        Map.Entry<Object, T>[] slots = this.slots;
        int n = slots.length;
        for (int i = 0; i < n; ++i) {
            if (!value.equals(slots[i])) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object value) {
        Map.Entry<Object, T>[] slots = this.slots;
        for (int i = slots.length - 1; i >= 0; --i) {
            if (!value.equals(slots[i])) continue;
            return i;
        }
        return -1;
    }

    @Override
    public T get(int index) {
        Map.Entry<Object, T> slot = this.slots[index];
        if (slot != null) {
            return slot.getValue();
        }
        return null;
    }

    @Override
    public Map.Entry<Object, T> getEntry(int index) {
        return this.slots[index];
    }

    @Override
    public STreeLeaf<T> updated(int index, T newValue, STreeContext<T> tree) {
        if (index < 0 || index >= this.slots.length) {
            throw new IndexOutOfBoundsException(Integer.toString(index));
        }
        return this.updatedSlot(index, newValue);
    }

    private STreeLeaf<T> updatedSlot(int index, T newValue) {
        Map.Entry<Object, T>[] oldSlots = this.slots;
        Map.Entry<Object, T> oldSlot = oldSlots[index];
        if (newValue != oldSlot.getValue()) {
            int n = oldSlots.length;
            Map.Entry[] newSlots = new Map.Entry[n];
            System.arraycopy(oldSlots, 0, newSlots, 0, n);
            newSlots[index] = new AbstractMap.SimpleImmutableEntry<Object, T>(oldSlot.getKey(), newValue);
            return new STreeLeaf<T>(newSlots);
        }
        return this;
    }

    @Override
    public STreeLeaf<T> inserted(int index, T newValue, Object id, STreeContext<T> tree) {
        if (index < 0 || index > this.slots.length) {
            throw new IndexOutOfBoundsException(Integer.toString(index));
        }
        return this.insertedSlot(index, newValue, id, tree);
    }

    private STreeLeaf<T> insertedSlot(int index, T newValue, Object id, STreeContext<T> tree) {
        if (id == null) {
            id = tree.identify(newValue);
        }
        Map.Entry<Object, T>[] oldSlots = this.slots;
        int n = oldSlots.length + 1;
        Map.Entry[] newSlots = new Map.Entry[n];
        System.arraycopy(oldSlots, 0, newSlots, 0, index);
        newSlots[index] = new AbstractMap.SimpleImmutableEntry<Object, T>(id, newValue);
        System.arraycopy(oldSlots, index, newSlots, index + 1, n - (index + 1));
        return new STreeLeaf<T>(newSlots);
    }

    @Override
    public STreeLeaf<T> removed(int index, STreeContext<T> tree) {
        if (index < 0 || index >= this.slots.length) {
            throw new IndexOutOfBoundsException(Integer.toString(index));
        }
        if (this.slots.length > 1) {
            return this.removedSlot(index);
        }
        return STreeLeaf.empty();
    }

    private STreeLeaf<T> removedSlot(int index) {
        Map.Entry<Object, T>[] oldSlots = this.slots;
        int n = oldSlots.length - 1;
        Map.Entry[] newSlots = new Map.Entry[n];
        System.arraycopy(oldSlots, 0, newSlots, 0, index);
        System.arraycopy(oldSlots, index + 1, newSlots, index, n - index);
        return new STreeLeaf<T>(newSlots);
    }

    @Override
    public STreeLeaf<T> removed(Object object, STreeContext<T> tree) {
        int index = this.indexOf(object);
        if (index >= 0) {
            if (this.slots.length > 1) {
                return this.removedSlot(index);
            }
            return STreeLeaf.empty();
        }
        return this;
    }

    @Override
    public STreeLeaf<T> drop(int lower, STreeContext<T> tree) {
        if (lower > 0) {
            Map.Entry<Object, T>[] oldSlots = this.slots;
            int k = oldSlots.length;
            if (lower < k) {
                int n = k - lower;
                Map.Entry[] newSlots = new Map.Entry[n];
                System.arraycopy(oldSlots, lower, newSlots, 0, n);
                return new STreeLeaf<T>(newSlots);
            }
            return STreeLeaf.empty();
        }
        return this;
    }

    @Override
    public STreeLeaf<T> take(int upper, STreeContext<T> tree) {
        Map.Entry<Object, T>[] oldSlots = this.slots;
        if (upper < oldSlots.length) {
            if (upper > 0) {
                Map.Entry[] newSlots = new Map.Entry[upper];
                System.arraycopy(oldSlots, 0, newSlots, 0, upper);
                return new STreeLeaf<T>(newSlots);
            }
            return STreeLeaf.empty();
        }
        return this;
    }

    @Override
    public STreePage<T> balanced(STreeContext<T> tree) {
        int n = this.slots.length;
        if (n > 1 && tree.pageShouldSplit(this)) {
            int x = n >>> 1;
            return this.split(x);
        }
        return this;
    }

    @Override
    public STreeNode<T> split(int x) {
        STreePage[] newPages = new STreePage[2];
        STreePage newLeftPage = this.splitLeft(x);
        STreePage newRightPage = this.splitRight(x);
        newPages[0] = newLeftPage;
        newPages[1] = newRightPage;
        int[] newKnots = new int[]{x};
        return new STreeNode(newPages, newKnots, this.slots.length);
    }

    @Override
    public STreeLeaf<T> splitLeft(int x) {
        Map.Entry<Object, T>[] oldSlots = this.slots;
        Map.Entry[] newSlots = new Map.Entry[x];
        System.arraycopy(oldSlots, 0, newSlots, 0, x);
        return new STreeLeaf<T>(newSlots);
    }

    @Override
    public STreeLeaf<T> splitRight(int x) {
        Map.Entry<Object, T>[] oldSlots = this.slots;
        int y = oldSlots.length - x;
        Map.Entry[] newSlots = new Map.Entry[y];
        System.arraycopy(oldSlots, x, newSlots, 0, y);
        return new STreeLeaf<T>(newSlots);
    }

    @Override
    public void copyToArray(Object[] array, int offset) {
        Map.Entry<Object, T>[] slots = this.slots;
        int n = slots.length;
        for (int i = 0; i < n; ++i) {
            array[offset + i] = slots[i].getValue();
        }
    }

    @Override
    public Cursor<Map.Entry<Object, T>> entryIterator() {
        return Cursor.array((Object[])this.slots);
    }

    @Override
    public Cursor<Map.Entry<Object, T>> reverseEntryIterator() {
        return Cursor.array((Object[])this.slots, (int)this.slots.length);
    }
}

