/*
 * Decompiled with CFR 0.152.
 */
package swim.collections;

import java.util.Map;
import swim.collections.STreeContext;
import swim.collections.STreeLeaf;
import swim.util.Cursor;

public abstract class STreePage<T> {
    public static <T> STreePage<T> empty() {
        return STreeLeaf.empty();
    }

    public abstract boolean isEmpty();

    public abstract int size();

    public abstract int arity();

    public abstract boolean contains(Object var1);

    public abstract int indexOf(Object var1);

    public abstract int lastIndexOf(Object var1);

    public abstract T get(int var1);

    public abstract Map.Entry<Object, T> getEntry(int var1);

    public abstract STreePage<T> updated(int var1, T var2, STreeContext<T> var3);

    public abstract STreePage<T> inserted(int var1, T var2, Object var3, STreeContext<T> var4);

    public STreePage<T> appended(T newValue, Object id, STreeContext<T> tree) {
        return this.inserted(this.size(), newValue, id, tree);
    }

    public STreePage<T> prepended(T newValue, Object id, STreeContext<T> tree) {
        return this.inserted(0, newValue, id, tree);
    }

    public abstract STreePage<T> removed(int var1, STreeContext<T> var2);

    public abstract STreePage<T> removed(Object var1, STreeContext<T> var2);

    public abstract STreePage<T> drop(int var1, STreeContext<T> var2);

    public abstract STreePage<T> take(int var1, STreeContext<T> var2);

    public abstract STreePage<T> balanced(STreeContext<T> var1);

    public abstract STreePage<T> split(int var1);

    public abstract STreePage<T> splitLeft(int var1);

    public abstract STreePage<T> splitRight(int var1);

    public abstract void copyToArray(Object[] var1, int var2);

    public Cursor<T> iterator() {
        return Cursor.values(this.entryIterator());
    }

    public Cursor<Object> keyIterator() {
        return Cursor.keys(this.entryIterator());
    }

    public abstract Cursor<Map.Entry<Object, T>> entryIterator();

    public Cursor<T> reverseIterator() {
        return Cursor.values(this.reverseEntryIterator());
    }

    public Cursor<Object> reverseKeyIterator() {
        return Cursor.keys(this.reverseEntryIterator());
    }

    public abstract Cursor<Map.Entry<Object, T>> reverseEntryIterator();
}

