/*
 * Decompiled with CFR 0.152.
 */
package swim.collections;

import java.util.AbstractMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;

final class ArrayMapIterator<K, V>
implements Iterator<Map.Entry<K, V>> {
    final Object[] slots;
    int index;

    ArrayMapIterator(Object[] slots) {
        this.slots = slots;
    }

    @Override
    public boolean hasNext() {
        return this.index + 1 < this.slots.length;
    }

    @Override
    public Map.Entry<K, V> next() {
        int index = this.index;
        if (index + 1 >= this.slots.length) {
            throw new NoSuchElementException();
        }
        Object key = this.slots[index];
        Object value = this.slots[index + 1];
        this.index = index + 2;
        return new AbstractMap.SimpleImmutableEntry<Object, Object>(key, value);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

