/*
 * Decompiled with CFR 0.152.
 */
package swim.collections;

import java.util.Iterator;
import swim.codec.Debug;
import swim.codec.Format;
import swim.codec.Output;
import swim.collections.ArraySetIterator;
import swim.util.Murmur3;

final class ArraySet<T>
implements Debug {
    final Object[] slots;
    private static int hashSeed;
    private static ArraySet<Object> empty;

    ArraySet(Object[] slots) {
        this.slots = slots;
    }

    public boolean isEmpty() {
        return this.slots.length == 0;
    }

    public int size() {
        return this.slots.length;
    }

    public boolean contains(Object elem) {
        int n = this.slots.length;
        for (int i = 0; i < n; ++i) {
            if (!elem.equals(this.slots[i])) continue;
            return true;
        }
        return false;
    }

    public T head() {
        if (this.slots.length > 0) {
            return (T)this.slots[0];
        }
        return null;
    }

    public T next(Object elem) {
        int n = this.slots.length;
        if (n > 0 && elem == null) {
            return (T)this.slots[0];
        }
        for (int i = 0; i < n; ++i) {
            if (!elem.equals(this.slots[i]) || i + 1 >= n) continue;
            return (T)this.slots[i + 1];
        }
        return null;
    }

    public ArraySet<T> added(T elem) {
        Object[] oldSlots = this.slots;
        int n = oldSlots.length;
        for (int i = 0; i < n; ++i) {
            if (!elem.equals(oldSlots[i])) continue;
            return this;
        }
        Object[] newSlots = new Object[n + 1];
        System.arraycopy(oldSlots, 0, newSlots, 0, n);
        newSlots[n] = elem;
        return new ArraySet<T>(newSlots);
    }

    public ArraySet<T> removed(T elem) {
        Object[] oldSlots = this.slots;
        int n = oldSlots.length;
        for (int i = 0; i < n; ++i) {
            if (!elem.equals(oldSlots[i])) continue;
            if (n == 1) {
                return ArraySet.empty();
            }
            Object[] newSlots = new Object[n - 1];
            System.arraycopy(oldSlots, 0, newSlots, 0, i);
            System.arraycopy(oldSlots, i + 1, newSlots, i, n - 1 - i);
            return new ArraySet<T>(newSlots);
        }
        return this;
    }

    boolean isUnary() {
        return this.slots.length == 1;
    }

    T unaryElem() {
        return (T)this.slots[0];
    }

    T elemAt(int index) {
        return (T)this.slots[index];
    }

    public Iterator<T> iterator() {
        return new ArraySetIterator(this.slots);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof ArraySet) {
            ArraySet that = (ArraySet)other;
            if (this.size() == that.size()) {
                Iterator<T> those = that.iterator();
                while (those.hasNext()) {
                    if (this.contains(those.next())) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(ArraySet.class);
        }
        int a = 0;
        int b = 0;
        int c = 1;
        Iterator<T> these = this.iterator();
        while (these.hasNext()) {
            int h = Murmur3.hash(these.next());
            a ^= h;
            b += h;
            if (h == 0) continue;
            c *= h;
        }
        return Murmur3.mash((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)hashSeed, (int)a), (int)b), (int)c));
    }

    public <U> Output<U> debug(Output<U> output) {
        output = output.write("ArraySet").write(46);
        Iterator<T> these = this.iterator();
        if (these.hasNext()) {
            output = output.write("of").write(40).debug(these.next());
            while (these.hasNext()) {
                output = output.write(", ").debug(these.next());
            }
        } else {
            output = output.write("empty").write(40);
        }
        output = output.write(41);
        return output;
    }

    public String toString() {
        return Format.debug((Object)this);
    }

    public static <T> ArraySet<T> empty() {
        if (empty == null) {
            empty = new ArraySet<T>(new Object[0]);
        }
        return empty;
    }

    public static <T> ArraySet<T> of(T ... elems) {
        int n = elems.length;
        Object[] slots = new Object[n];
        System.arraycopy(elems, 0, slots, 0, n);
        return new ArraySet<T>(slots);
    }
}

