/*
 * Decompiled with CFR 0.152.
 */
package swim.collections;

import java.util.Iterator;
import java.util.NoSuchElementException;
import swim.collections.ArraySet;
import swim.collections.HashTrieSet;

final class HashTrieSetIterator<T>
implements Iterator<T> {
    final Object[] nodes = new Object[8];
    final int[] stack = new int[24];
    int depth = 0;
    int stackPointer = 0;

    HashTrieSetIterator(HashTrieSet<T> tree) {
        this.setNode(tree);
        this.setSlotIndex(0);
        this.setTreeMap(tree.treeMap);
        this.setLeafMap(tree.leafMap);
    }

    Object getNode() {
        return this.nodes[this.depth];
    }

    void setNode(Object node) {
        this.nodes[this.depth] = node;
    }

    int getSlotIndex() {
        return this.stack[this.stackPointer];
    }

    void setSlotIndex(int index) {
        this.stack[this.stackPointer] = index;
    }

    int getTreeMap() {
        return this.stack[this.stackPointer + 1];
    }

    void setTreeMap(int treeMap) {
        this.stack[this.stackPointer + 1] = treeMap;
    }

    int getLeafMap() {
        return this.stack[this.stackPointer + 2];
    }

    void setLeafMap(int leafMap) {
        this.stack[this.stackPointer + 2] = leafMap;
    }

    int follow(int treeMap, int leafMap) {
        return leafMap & 1 | (treeMap & 1) << 1;
    }

    void push(HashTrieSet<T> tree) {
        ++this.depth;
        this.setNode(tree);
        this.stackPointer += 3;
        this.setSlotIndex(0);
        this.setTreeMap(tree.treeMap);
        this.setLeafMap(tree.leafMap);
    }

    void push(ArraySet<T> knot) {
        ++this.depth;
        this.setNode(knot);
        this.stackPointer += 3;
        this.setSlotIndex(0);
    }

    void pop() {
        this.setNode(null);
        --this.depth;
        this.setSlotIndex(0);
        this.setTreeMap(0);
        this.setLeafMap(0);
        this.stackPointer -= 3;
        this.setSlotIndex(this.getSlotIndex() + 1);
        this.setTreeMap(this.getTreeMap() >>> 1);
        this.setLeafMap(this.getLeafMap() >>> 1);
    }

    @Override
    public boolean hasNext() {
        block6: while (true) {
            Object node;
            if ((node = this.getNode()) instanceof HashTrieSet) {
                int leafMap;
                HashTrieSet tree = (HashTrieSet)node;
                int treeMap = this.getTreeMap();
                if ((treeMap | (leafMap = this.getLeafMap())) != 0) {
                    switch (this.follow(treeMap, leafMap)) {
                        case 0: {
                            this.setTreeMap(treeMap >>> 1);
                            this.setLeafMap(leafMap >>> 1);
                            continue block6;
                        }
                        case 1: {
                            return true;
                        }
                        case 2: {
                            this.push(tree.treeAt(this.getSlotIndex()));
                            continue block6;
                        }
                        case 3: {
                            this.push(tree.knotAt(this.getSlotIndex()));
                            continue block6;
                        }
                        default: {
                            throw new AssertionError();
                        }
                    }
                }
                if (this.depth > 0) {
                    this.pop();
                    continue;
                }
                return false;
            }
            if (!(node instanceof ArraySet)) break;
            ArraySet knot = (ArraySet)node;
            if (this.getSlotIndex() < knot.size()) {
                return true;
            }
            this.pop();
        }
        throw new AssertionError();
    }

    @Override
    public T next() {
        block6: while (true) {
            Object node;
            if ((node = this.getNode()) instanceof HashTrieSet) {
                int leafMap;
                HashTrieSet tree = (HashTrieSet)node;
                int treeMap = this.getTreeMap();
                int slotMap = treeMap | (leafMap = this.getLeafMap());
                if (slotMap != 0) {
                    switch (this.follow(treeMap, leafMap)) {
                        case 0: {
                            this.setTreeMap(treeMap >>> 1);
                            this.setLeafMap(leafMap >>> 1);
                            continue block6;
                        }
                        case 1: {
                            int slotIndex = this.getSlotIndex();
                            Object elem = tree.leafAt(slotIndex);
                            this.setSlotIndex(slotIndex + 1);
                            this.setTreeMap(treeMap >>> 1);
                            this.setLeafMap(leafMap >>> 1);
                            return elem;
                        }
                        case 2: {
                            this.push(tree.treeAt(this.getSlotIndex()));
                            continue block6;
                        }
                        case 3: {
                            this.push(tree.knotAt(this.getSlotIndex()));
                            continue block6;
                        }
                        default: {
                            throw new AssertionError();
                        }
                    }
                }
                if (this.depth > 0) {
                    this.pop();
                    continue;
                }
                throw new NoSuchElementException();
            }
            if (!(node instanceof ArraySet)) break;
            ArraySet knot = (ArraySet)node;
            int slotIndex = this.getSlotIndex();
            if (slotIndex < knot.size()) {
                Object elem = knot.elemAt(slotIndex);
                this.setSlotIndex(slotIndex + 1);
                return elem;
            }
            this.pop();
        }
        throw new AssertionError();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

