/*
 * Decompiled with CFR 0.152.
 */
package swim.collections;

import java.util.AbstractMap;
import java.util.Iterator;
import java.util.Map;
import swim.codec.Debug;
import swim.codec.Format;
import swim.codec.Output;
import swim.collections.ArrayMapIterator;
import swim.util.Murmur3;

final class ArrayMap<K, V>
implements Debug {
    final Object[] slots;
    private static int hashSeed;
    private static ArrayMap<Object, Object> empty;

    ArrayMap(Object[] slots) {
        this.slots = slots;
    }

    public boolean isEmpty() {
        return this.slots.length == 0;
    }

    public int size() {
        return this.slots.length >> 1;
    }

    public boolean containsKey(Object key) {
        int n = this.slots.length;
        for (int i = 0; i < n; i += 2) {
            if (!key.equals(this.slots[i])) continue;
            return true;
        }
        return false;
    }

    public boolean containsValue(Object value) {
        int n = this.slots.length;
        for (int i = 0; i < n; i += 2) {
            Object v = this.slots[i + 1];
            if (!(value == null ? v == null : value.equals(v))) continue;
            return true;
        }
        return false;
    }

    public Map.Entry<K, V> head() {
        if (this.slots.length > 1) {
            return new AbstractMap.SimpleImmutableEntry<Object, Object>(this.slots[0], this.slots[1]);
        }
        return null;
    }

    public K headKey() {
        if (this.slots.length > 1) {
            return (K)this.slots[0];
        }
        return null;
    }

    public V headValue() {
        if (this.slots.length > 1) {
            return (V)this.slots[1];
        }
        return null;
    }

    public Map.Entry<K, V> next(Object key) {
        int n = this.slots.length;
        if (n > 1 && key == null) {
            return new AbstractMap.SimpleImmutableEntry<Object, Object>(this.slots[0], this.slots[1]);
        }
        for (int i = 0; i < n; i += 2) {
            if (!key.equals(this.slots[i]) || i + 3 >= n) continue;
            return new AbstractMap.SimpleImmutableEntry<Object, Object>(this.slots[i + 2], this.slots[i + 3]);
        }
        return null;
    }

    public K nextKey(Object key) {
        int n = this.slots.length;
        if (n > 1 && key == null) {
            return (K)this.slots[0];
        }
        for (int i = 0; i < n; i += 2) {
            if (!key.equals(this.slots[i]) || i + 3 >= n) continue;
            return (K)this.slots[i + 2];
        }
        return null;
    }

    public V nextValue(Object key) {
        int n = this.slots.length;
        if (n > 1 && key == null) {
            return (V)this.slots[1];
        }
        for (int i = 0; i < n; i += 2) {
            if (!key.equals(this.slots[i]) || i + 3 >= n) continue;
            return (V)this.slots[i + 3];
        }
        return null;
    }

    public V get(Object key) {
        int n = this.slots.length;
        for (int i = 0; i < n; i += 2) {
            if (!key.equals(this.slots[i])) continue;
            return (V)this.slots[i + 1];
        }
        return null;
    }

    public ArrayMap<K, V> updated(K key, V value) {
        Object[] oldSlots = this.slots;
        int n = oldSlots.length;
        for (int i = 0; i < n; i += 2) {
            if (!key.equals(oldSlots[i])) continue;
            Object v = oldSlots[i + 1];
            if (value == null ? v == null : value.equals(v)) {
                return this;
            }
            Object[] newSlots = new Object[n];
            System.arraycopy(oldSlots, 0, newSlots, 0, n);
            newSlots[i] = key;
            newSlots[i + 1] = value;
            return new ArrayMap<K, V>(newSlots);
        }
        Object[] newSlots = new Object[n + 2];
        System.arraycopy(oldSlots, 0, newSlots, 0, n);
        newSlots[n] = key;
        newSlots[n + 1] = value;
        return new ArrayMap<K, V>(newSlots);
    }

    public ArrayMap<K, V> removed(Object key) {
        Object[] oldSlots = this.slots;
        int n = oldSlots.length;
        for (int i = 0; i < n; ++i) {
            if (!key.equals(oldSlots[i])) continue;
            if (n == 2) {
                return ArrayMap.empty();
            }
            Object[] newSlots = new Object[n - 2];
            System.arraycopy(oldSlots, 0, newSlots, 0, i);
            System.arraycopy(oldSlots, i + 2, newSlots, i, n - 2 - i);
            return new ArrayMap<K, V>(newSlots);
        }
        return this;
    }

    boolean isUnary() {
        return this.slots.length == 2;
    }

    K unaryKey() {
        return (K)this.slots[0];
    }

    V unaryValue() {
        return (V)this.slots[1];
    }

    K keyAt(int index) {
        return (K)this.slots[index << 1];
    }

    V valueAt(int index) {
        return (V)this.slots[(index << 1) + 1];
    }

    public Iterator<Map.Entry<K, V>> iterator() {
        return new ArrayMapIterator(this.slots);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof ArrayMap) {
            ArrayMap that = (ArrayMap)other;
            if (this.size() == that.size()) {
                Iterator<Map.Entry<K, V>> those = that.iterator();
                while (those.hasNext()) {
                    Map.Entry<K, V> entry = those.next();
                    V value = this.get(entry.getKey());
                    V v = entry.getValue();
                    if (!(value == null ? v != null : !value.equals(v))) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(ArrayMap.class);
        }
        int a = 0;
        int b = 0;
        int c = 1;
        Iterator<Map.Entry<K, V>> these = this.iterator();
        while (these.hasNext()) {
            Map.Entry<K, V> entry = these.next();
            int h = Murmur3.mix((int)Murmur3.hash(entry.getKey()), (int)Murmur3.hash(entry.getValue()));
            a ^= h;
            b += h;
            if (h == 0) continue;
            c *= h;
        }
        return Murmur3.mash((int)Murmur3.mix((int)Murmur3.mix((int)Murmur3.mix((int)hashSeed, (int)a), (int)b), (int)c));
    }

    public <T> Output<T> debug(Output<T> output) {
        output = output.write("ArrayMap").write(46).write("empty").write(40).write(41);
        Iterator<Map.Entry<K, V>> these = this.iterator();
        while (these.hasNext()) {
            Map.Entry<K, V> entry = these.next();
            output = output.write(46).write("updated").write(40).debug(entry.getKey()).write(", ").debug(entry.getValue()).write(41);
        }
        return output;
    }

    public String toString() {
        return Format.debug((Object)this);
    }

    public static <K, V> ArrayMap<K, V> empty() {
        if (empty == null) {
            empty = new ArrayMap<K, V>(new Object[0]);
        }
        return empty;
    }
}

