/*
 * Decompiled with CFR 0.152.
 */
package swim.collections;

import java.util.Comparator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import swim.codec.Debug;
import swim.codec.Format;
import swim.codec.Output;
import swim.collections.BTree;
import swim.collections.BTreeContext;
import swim.collections.BTreePage;
import swim.util.CombinerFunction;
import swim.util.Cursor;
import swim.util.OrderedMapCursor;
import swim.util.ReducedMap;

public class BTreeMap<K, V, U>
extends BTreeContext<K, V>
implements ReducedMap<K, V, U>,
Cloneable,
Debug {
    volatile BTreePage<K, V, U> root;
    static final AtomicReferenceFieldUpdater<BTreeMap, BTreePage> ROOT = AtomicReferenceFieldUpdater.newUpdater(BTreeMap.class, BTreePage.class, "root");

    protected BTreeMap(BTreePage<K, V, U> root) {
        this.root = root;
    }

    public BTreeMap() {
        this(BTreePage.empty());
    }

    final BTreePage<K, V, U> root() {
        return ROOT.get(this);
    }

    public boolean isEmpty() {
        BTreePage<K, V, U> root = this.root();
        return root.isEmpty();
    }

    public int size() {
        BTreePage<K, V, U> root = this.root();
        return root.size();
    }

    public boolean containsKey(Object key) {
        BTreePage<K, V, U> root = this.root();
        return root.containsKey(key, this);
    }

    public boolean containsValue(Object value) {
        BTreePage<K, V, U> root = this.root();
        return root.containsValue(value);
    }

    public int indexOf(Object key) {
        BTreePage<K, V, U> root = this.root();
        return root.indexOf(key, this);
    }

    public V get(Object key) {
        BTreePage<K, V, U> root = this.root();
        return root.get(key, this);
    }

    public Map.Entry<K, V> getEntry(Object key) {
        BTreePage<K, V, U> root = this.root();
        return root.getEntry(key, this);
    }

    public Map.Entry<K, V> getIndex(int index) {
        BTreePage<K, V, U> root = this.root();
        return root.getIndex(index);
    }

    public Map.Entry<K, V> firstEntry() {
        BTreePage<K, V, U> root = this.root();
        return root.firstEntry();
    }

    public K firstKey() {
        BTreePage<K, V, U> root = this.root();
        Map.Entry<K, V> entry = root.firstEntry();
        if (entry != null) {
            return entry.getKey();
        }
        return null;
    }

    public V firstValue() {
        BTreePage<K, V, U> root = this.root();
        Map.Entry<K, V> entry = root.firstEntry();
        if (entry != null) {
            return entry.getValue();
        }
        return null;
    }

    public Map.Entry<K, V> lastEntry() {
        BTreePage<K, V, U> root = this.root();
        return root.lastEntry();
    }

    public K lastKey() {
        BTreePage<K, V, U> root = this.root();
        Map.Entry<K, V> entry = root.lastEntry();
        if (entry != null) {
            return entry.getKey();
        }
        return null;
    }

    public V lastValue() {
        BTreePage<K, V, U> root = this.root();
        Map.Entry<K, V> entry = root.lastEntry();
        if (entry != null) {
            return entry.getValue();
        }
        return null;
    }

    public Map.Entry<K, V> nextEntry(K key) {
        BTreePage<K, V, U> root = this.root();
        return root.nextEntry(key, this);
    }

    public K nextKey(K key) {
        BTreePage<K, V, U> root = this.root();
        Map.Entry<K, V> entry = root.nextEntry(key, this);
        if (entry != null) {
            return entry.getKey();
        }
        return null;
    }

    public V nextValue(K key) {
        BTreePage<K, V, U> root = this.root();
        Map.Entry<K, V> entry = root.nextEntry(key, this);
        if (entry != null) {
            return entry.getValue();
        }
        return null;
    }

    public Map.Entry<K, V> previousEntry(K key) {
        BTreePage<K, V, U> root = this.root();
        return root.previousEntry(key, this);
    }

    public K previousKey(K key) {
        BTreePage<K, V, U> root = this.root();
        Map.Entry<K, V> entry = root.previousEntry(key, this);
        if (entry != null) {
            return entry.getKey();
        }
        return null;
    }

    public V previousValue(K key) {
        BTreePage<K, V, U> root = this.root();
        Map.Entry<K, V> entry = root.previousEntry(key, this);
        if (entry != null) {
            return entry.getValue();
        }
        return null;
    }

    public V put(K key, V newValue) {
        BTreePage<K, V, U> newRoot;
        BTreePage<K, V, U> oldRoot;
        while ((oldRoot = this.root()) != (newRoot = oldRoot.updated(key, newValue, this))) {
            if (newRoot.size() > oldRoot.size()) {
                newRoot = newRoot.balanced(this);
            }
            if (!ROOT.compareAndSet(this, oldRoot, newRoot)) continue;
            break;
        }
        return oldRoot.get(key, this);
    }

    public void putAll(Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public V remove(Object key) {
        BTreePage<K, V, U> newRoot;
        BTreePage<K, V, U> oldRoot;
        while ((oldRoot = this.root()) != (newRoot = oldRoot.removed(key, this).balanced(this))) {
            if (!ROOT.compareAndSet(this, oldRoot, newRoot)) continue;
            return oldRoot.get(key, this);
        }
        return null;
    }

    public BTreeMap<K, V, U> drop(int lower) {
        BTreePage newRoot;
        BTreePage<K, V, U> oldRoot;
        do {
            oldRoot = this.root();
        } while (lower > 0 && oldRoot.size() > 0 && !ROOT.compareAndSet(this, oldRoot, newRoot = lower < oldRoot.size() ? oldRoot.drop(lower, this).balanced(this) : BTreePage.empty()));
        return this;
    }

    public BTreeMap<K, V, U> take(int upper) {
        BTreePage newRoot;
        BTreePage<K, V, U> oldRoot;
        while (upper < (oldRoot = this.root()).size() && oldRoot.size() > 0 && !ROOT.compareAndSet(this, oldRoot, newRoot = upper > 0 ? oldRoot.take(upper, this).balanced(this) : BTreePage.empty())) {
        }
        return this;
    }

    public void clear() {
        BTreePage newRoot;
        BTreePage<K, V, U> oldRoot;
        while ((oldRoot = this.root()) != (newRoot = BTreePage.empty()) && !ROOT.compareAndSet(this, oldRoot, newRoot)) {
        }
    }

    public BTreeMap<K, V, U> updated(K key, V newValue) {
        BTreePage<K, V, U> oldRoot = this.root();
        BTreePage<K, V, U> newRoot = oldRoot.updated(key, newValue, this);
        if (newRoot.size() > oldRoot.size()) {
            newRoot = newRoot.balanced(this);
        }
        return this.copy(newRoot);
    }

    public BTreeMap<K, V, U> removed(K key) {
        BTreePage<K, V, U> newRoot;
        BTreePage<K, V, U> oldRoot = this.root();
        if (oldRoot != (newRoot = oldRoot.removed(key, this))) {
            newRoot = newRoot.balanced(this);
        }
        return this.copy(newRoot);
    }

    public BTreeMap<K, V, U> cleared() {
        return this.copy(BTreePage.empty());
    }

    public U reduced(U identity, CombinerFunction<? super V, U> accumulator, CombinerFunction<U, U> combiner) {
        BTreePage<K, V, U> newRoot;
        BTreePage<K, ? super V, U> oldRoot;
        while ((oldRoot = this.root()) != (newRoot = oldRoot.reduced(identity, accumulator, combiner)) && !ROOT.compareAndSet(this, oldRoot, newRoot)) {
        }
        return newRoot.fold();
    }

    public BTree<K, V> snapshot() {
        BTreePage<K, V, U> root = this.root();
        return new BTree<K, V>(root);
    }

    public OrderedMapCursor<K, V> iterator() {
        BTreePage<K, V, U> root = this.root();
        return root.iterator();
    }

    public Cursor<K> keyIterator() {
        BTreePage<K, V, U> root = this.root();
        return root.keyIterator();
    }

    public Cursor<V> valueIterator() {
        BTreePage<K, V, U> root = this.root();
        return root.valueIterator();
    }

    public OrderedMapCursor<K, V> reverseIterator() {
        BTreePage<K, V, U> root = this.root();
        return root.reverseIterator();
    }

    public Cursor<K> reverseKeyIterator() {
        BTreePage<K, V, U> root = this.root();
        return root.reverseKeyIterator();
    }

    public Cursor<V> reverseValueIterator() {
        BTreePage<K, V, U> root = this.root();
        return root.reverseValueIterator();
    }

    public BTreeMap<K, V, U> clone() {
        BTreePage<K, V, U> root = this.root();
        return this.copy(root);
    }

    protected BTreeMap<K, V, U> copy(BTreePage<K, V, U> root) {
        return new BTreeMap<K, V, U>(root);
    }

    public Comparator<? super K> comparator() {
        return null;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof Map) {
            Map that = (Map)other;
            BTreePage<K, V, U> root = this.root();
            if (root.size() == that.size()) {
                for (Map.Entry entry : that.entrySet()) {
                    V value = root.get(entry.getKey(), this);
                    Object v = entry.getValue();
                    if (!(value == null ? v != null : !value.equals(v))) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int code = 0;
        OrderedMapCursor<K, V> these = this.iterator();
        while (these.hasNext()) {
            code += ((Map.Entry)these.next()).hashCode();
        }
        return code;
    }

    public <T> Output<T> debug(Output<T> output) {
        output = output.write("BTreeMap").write(46).write("empty").write(40).write(41);
        OrderedMapCursor<K, V> these = this.iterator();
        while (these.hasNext()) {
            Map.Entry entry = (Map.Entry)these.next();
            output = output.write(46).write("updated").write(40).debug(entry.getKey()).write(", ").debug(entry.getValue()).write(41);
        }
        return output;
    }

    public String toString() {
        return Format.debug((Object)this);
    }

    public static <K, V, U> BTreeMap<K, V, U> empty() {
        return new BTreeMap<K, V, U>();
    }

    public static <K, V, U> BTreeMap<K, V, U> from(Map<? extends K, ? extends V> map) {
        BTreeMap<K, V, U> tree = new BTreeMap<K, V, U>();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            tree.put(entry.getKey(), entry.getValue());
        }
        return tree;
    }
}

