/*
 * Decompiled with CFR 0.152.
 */
package swim.collections;

import java.util.Map;
import java.util.NoSuchElementException;
import swim.collections.BTreePage;
import swim.util.OrderedMapCursor;

final class BTreeNodeCursor<K, V, U>
implements OrderedMapCursor<K, V> {
    final BTreePage<K, V, U>[] pages;
    long index;
    int pageIndex;
    OrderedMapCursor<K, V> pageCursor;

    BTreeNodeCursor(BTreePage<K, V, U>[] pages, long index, int pageIndex, OrderedMapCursor<K, V> pageCursor) {
        this.pages = pages;
        this.index = index;
        this.pageIndex = pageIndex;
        this.pageCursor = pageCursor;
    }

    BTreeNodeCursor(BTreePage<K, V, U>[] pages, long index, int pageIndex) {
        this(pages, index, pageIndex, null);
    }

    BTreeNodeCursor(BTreePage<K, V, U>[] pages) {
        this(pages, 0L, 0, null);
    }

    long pageSize(BTreePage<K, V, U> page) {
        return page.size();
    }

    OrderedMapCursor<K, V> pageCursor(BTreePage<K, V, U> page) {
        return page.iterator();
    }

    OrderedMapCursor<K, V> reversePageCursor(BTreePage<K, V, U> page) {
        return page.reverseIterator();
    }

    public boolean isEmpty() {
        while (true) {
            if (this.pageCursor != null) {
                if (!this.pageCursor.isEmpty()) {
                    return false;
                }
                this.pageCursor = null;
                continue;
            }
            if (this.pageIndex >= this.pages.length) break;
            this.pageCursor = this.pageCursor(this.pages[this.pageIndex]);
            ++this.pageIndex;
        }
        this.pageIndex = this.pages.length;
        return true;
    }

    public Map.Entry<K, V> head() {
        while (true) {
            if (this.pageCursor != null) {
                if (!this.pageCursor.isEmpty()) {
                    return (Map.Entry)this.pageCursor.head();
                }
                this.pageCursor = null;
                continue;
            }
            if (this.pageIndex >= this.pages.length) break;
            this.pageCursor = this.pageCursor(this.pages[this.pageIndex]);
            ++this.pageIndex;
        }
        this.pageIndex = this.pages.length;
        throw new NoSuchElementException();
    }

    public void step() {
        while (true) {
            if (this.pageCursor != null) {
                if (!this.pageCursor.isEmpty()) {
                    ++this.index;
                    return;
                }
                this.pageCursor = null;
                continue;
            }
            if (this.pageIndex >= this.pages.length) break;
            this.pageCursor = this.pageCursor(this.pages[this.pageIndex]);
            ++this.pageIndex;
        }
        this.pageIndex = this.pages.length;
        throw new UnsupportedOperationException();
    }

    public void skip(long count) {
        while (count > 0L) {
            if (this.pageCursor != null) {
                if (this.pageCursor.hasNext()) {
                    ++this.index;
                    --count;
                    this.pageCursor.next();
                    continue;
                }
                this.pageCursor = null;
                continue;
            }
            if (this.pageIndex >= this.pages.length) break;
            BTreePage<K, V, U> page = this.pages[this.pageIndex];
            long pageSize = this.pageSize(page);
            ++this.pageIndex;
            if (pageSize < count) {
                this.pageCursor = this.pageCursor(page);
                if (count <= 0L) break;
                this.index += count;
                this.pageCursor.skip(count);
                count = 0L;
                break;
            }
            this.index += pageSize;
            count -= pageSize;
        }
    }

    public boolean hasNext() {
        while (true) {
            if (this.pageCursor != null) {
                if (this.pageCursor.hasNext()) {
                    return true;
                }
                this.pageCursor = null;
                continue;
            }
            if (this.pageIndex >= this.pages.length) break;
            this.pageCursor = this.pageCursor(this.pages[this.pageIndex]);
            ++this.pageIndex;
        }
        this.pageIndex = this.pages.length;
        return false;
    }

    public long nextIndexLong() {
        return this.index;
    }

    public K nextKey() {
        while (true) {
            if (this.pageCursor != null) {
                if (this.pageCursor.hasNext()) {
                    return (K)this.pageCursor.nextKey();
                }
                this.pageCursor = null;
                continue;
            }
            if (this.pageIndex >= this.pages.length) break;
            this.pageCursor = this.pageCursor(this.pages[this.pageIndex]);
            ++this.pageIndex;
        }
        this.pageIndex = this.pages.length;
        throw new NoSuchElementException();
    }

    public Map.Entry<K, V> next() {
        while (true) {
            if (this.pageCursor != null) {
                if (this.pageCursor.hasNext()) {
                    ++this.index;
                    return (Map.Entry)this.pageCursor.next();
                }
                this.pageCursor = null;
                continue;
            }
            if (this.pageIndex >= this.pages.length) break;
            this.pageCursor = this.pageCursor(this.pages[this.pageIndex]);
            ++this.pageIndex;
        }
        this.pageIndex = this.pages.length;
        throw new NoSuchElementException();
    }

    public boolean hasPrevious() {
        while (true) {
            if (this.pageCursor != null) {
                if (this.pageCursor.hasPrevious()) {
                    return true;
                }
                this.pageCursor = null;
                continue;
            }
            if (this.pageIndex <= 0) break;
            this.pageCursor = this.reversePageCursor(this.pages[this.pageIndex - 1]);
            --this.pageIndex;
        }
        this.pageIndex = 0;
        return false;
    }

    public long previousIndexLong() {
        return this.index - 1L;
    }

    public K previousKey() {
        while (true) {
            if (this.pageCursor != null) {
                if (this.pageCursor.hasPrevious()) {
                    return (K)this.pageCursor.previousKey();
                }
                this.pageCursor = null;
                continue;
            }
            if (this.pageIndex <= 0) break;
            this.pageCursor = this.reversePageCursor(this.pages[this.pageIndex - 1]);
            --this.pageIndex;
        }
        this.pageIndex = 0;
        throw new NoSuchElementException();
    }

    public Map.Entry<K, V> previous() {
        while (true) {
            if (this.pageCursor != null) {
                if (this.pageCursor.hasPrevious()) {
                    --this.index;
                    return (Map.Entry)this.pageCursor.previous();
                }
                this.pageCursor = null;
                continue;
            }
            if (this.pageIndex <= 0) break;
            this.pageCursor = this.reversePageCursor(this.pages[this.pageIndex - 1]);
            --this.pageIndex;
        }
        this.pageIndex = 0;
        throw new NoSuchElementException();
    }

    public void set(Map.Entry<K, V> newValue) {
        this.pageCursor.set(newValue);
    }

    public void remove() {
        this.pageCursor.remove();
    }
}

