/*
 * Decompiled with CFR 0.152.
 */
package swim.collections;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import swim.codec.Debug;
import swim.codec.Format;
import swim.codec.Output;
import swim.collections.FingerTrieSeqBuilder;
import swim.collections.FingerTrieSeqIterator;
import swim.util.Builder;
import swim.util.Murmur3;

public final class FingerTrieSeq<T>
implements List<T>,
Debug {
    final Object[] prefix;
    final FingerTrieSeq<Object[]> branch;
    final Object[] suffix;
    final int length;
    private static int hashSeed;
    static final Object[] EMPTY_LEAF;
    static final FingerTrieSeq<?> EMPTY;
    static final FingerTrieSeq<Object[]> EMPTY_NODE;

    FingerTrieSeq(Object[] prefix, FingerTrieSeq<Object[]> branch, Object[] suffix, int length) {
        if (length < 0) {
            throw new IllegalArgumentException("length overflow");
        }
        if (prefix.length + (branch.length << 5) + suffix.length != length) {
            throw new AssertionError((Object)("inconsistent length: " + length + "; prefix.length: " + prefix.length + "; branch.length: " + (branch.length << 5) + "; suffix.length: " + suffix.length));
        }
        this.prefix = prefix;
        this.branch = branch;
        this.suffix = suffix;
        this.length = length;
    }

    FingerTrieSeq() {
        this.prefix = EMPTY_LEAF;
        this.branch = this;
        this.suffix = EMPTY_LEAF;
        this.length = 0;
    }

    @Override
    public boolean isEmpty() {
        return this.length == 0;
    }

    @Override
    public int size() {
        return this.length;
    }

    @Override
    public boolean contains(Object elem) {
        for (T next : this) {
            if (!(elem == null ? next == null : elem.equals(next))) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> elems) {
        for (Object elem : elems) {
            if (this.contains(elem)) continue;
            return false;
        }
        return true;
    }

    @Override
    public T get(int index) {
        if (index < 0 || index >= this.length) {
            throw new IndexOutOfBoundsException(Integer.toString(index));
        }
        Object[] prefix = this.prefix;
        int n = index - prefix.length;
        if (n < 0) {
            return (T)prefix[index];
        }
        FingerTrieSeq<Object[]> branch = this.branch;
        int j = n - (branch.length << 5);
        if (j < 0) {
            return (T)branch.get(n >> 5)[n & 0x1F];
        }
        return (T)this.suffix[j];
    }

    @Override
    public T set(int index, T nwElem) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(T newElem) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends T> newElems) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(int index, T newElem) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> newElems) {
        throw new UnsupportedOperationException();
    }

    @Override
    public T remove(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object elem) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> elems) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> elems) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int indexOf(Object elem) {
        int n = this.length;
        for (int i = 0; i < n; ++i) {
            if (!(elem == null ? this.get(i) == null : elem.equals(this.get(i)))) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object elem) {
        for (int i = this.length - 1; i >= 0; --i) {
            if (!(elem == null ? this.get(i) == null : elem.equals(this.get(i)))) continue;
            return i;
        }
        return -1;
    }

    public FingerTrieSeq<T> updated(int index, T elem) {
        Object[] oldPrefix = this.prefix;
        int a = oldPrefix.length;
        int n = index - a;
        if (n < 0) {
            Object[] newPrefix = new Object[a];
            System.arraycopy(oldPrefix, 0, newPrefix, 0, a);
            newPrefix[index] = elem;
            return new FingerTrieSeq<T>(newPrefix, this.branch, this.suffix, this.length);
        }
        FingerTrieSeq<Object[]> oldBranch = this.branch;
        int j = n - (oldBranch.length << 5);
        if (j < 0) {
            Object[] oldInfix = oldBranch.get(n >> 5);
            Object[] newInfix = new Object[32];
            System.arraycopy(oldInfix, 0, newInfix, 0, 32);
            newInfix[n & 0x1F] = elem;
            FingerTrieSeq<Object[]> newBranch = oldBranch.updated(n >> 5, newInfix);
            return new FingerTrieSeq<T>(oldPrefix, newBranch, this.suffix, this.length);
        }
        Object[] oldSuffix = this.suffix;
        int b = oldSuffix.length;
        Object[] newSuffix = new Object[b];
        System.arraycopy(oldSuffix, 0, newSuffix, 0, b);
        newSuffix[j] = elem;
        return new FingerTrieSeq<T>(oldPrefix, oldBranch, newSuffix, this.length);
    }

    public T head() {
        if (this.length == 0) {
            throw new NoSuchElementException();
        }
        return (T)this.prefix[0];
    }

    public FingerTrieSeq<T> tail() {
        if (this.length == 0) {
            throw new UnsupportedOperationException();
        }
        return this.drop(1);
    }

    public FingerTrieSeq<T> body() {
        if (this.length == 0) {
            throw new UnsupportedOperationException();
        }
        return this.take(this.length - 1);
    }

    public T foot() {
        if (this.length == 0) {
            throw new NoSuchElementException();
        }
        if (this.length <= 32) {
            return (T)this.prefix[this.prefix.length - 1];
        }
        return (T)this.suffix[this.suffix.length - 1];
    }

    public FingerTrieSeq<T> drop(int lower) {
        if (lower <= 0) {
            return this;
        }
        if (lower >= this.length) {
            return EMPTY;
        }
        int n = lower - this.prefix.length;
        int k = this.length - lower;
        FingerTrieSeq<Object[]> oldBranch = this.branch;
        if (n == 0) {
            if (oldBranch.length > 0) {
                return new FingerTrieSeq<T>(oldBranch.head(), oldBranch.tail(), this.suffix, k);
            }
            return new FingerTrieSeq<T>(this.suffix, EMPTY_NODE, EMPTY_LEAF, k);
        }
        if (n < 0) {
            Object[] newPrefix = new Object[-n];
            System.arraycopy(this.prefix, lower, newPrefix, 0, -n);
            return new FingerTrieSeq<T>(newPrefix, oldBranch, this.suffix, k);
        }
        int j = n - (oldBranch.length << 5);
        if (j < 0) {
            FingerTrieSeq<Object[]> split = oldBranch.drop(n >> 5);
            Object[] oldPrefix = split.head();
            Object[] newPrefix = new Object[oldPrefix.length - (n & 0x1F)];
            System.arraycopy(oldPrefix, n & 0x1F, newPrefix, 0, newPrefix.length);
            return new FingerTrieSeq<T>(newPrefix, split.tail(), this.suffix, k);
        }
        Object[] newPrefix = new Object[k];
        System.arraycopy(this.suffix, j, newPrefix, 0, k);
        return new FingerTrieSeq<T>(newPrefix, EMPTY_NODE, EMPTY_LEAF, k);
    }

    public FingerTrieSeq<T> take(int upper) {
        if (upper <= 0) {
            return EMPTY;
        }
        if (upper >= this.length) {
            return this;
        }
        int n = upper - this.prefix.length;
        if (n == 0) {
            return new FingerTrieSeq<T>(this.prefix, EMPTY_NODE, EMPTY_LEAF, upper);
        }
        if (n < 0) {
            Object[] newPrefix = new Object[upper];
            System.arraycopy(this.prefix, 0, newPrefix, 0, upper);
            return new FingerTrieSeq<T>(newPrefix, EMPTY_NODE, EMPTY_LEAF, upper);
        }
        FingerTrieSeq<Object[]> oldBranch = this.branch;
        int j = n - (oldBranch.length << 5);
        if (j == 0) {
            if (oldBranch.length > 0) {
                return new FingerTrieSeq<T>(this.prefix, oldBranch.body(), oldBranch.foot(), upper);
            }
            return new FingerTrieSeq<T>(this.suffix, EMPTY_NODE, EMPTY_LEAF, upper);
        }
        if (j < 0) {
            FingerTrieSeq<Object[]> split = oldBranch.take((n + 31 & 0xFFFFFFE0) >> 5);
            Object[] oldSuffix = split.foot();
            Object[] newSuffix = new Object[(n & 0x1F ^ 0x1F) + 1 & 0x20 | n & 0x1F];
            System.arraycopy(oldSuffix, 0, newSuffix, 0, newSuffix.length);
            return new FingerTrieSeq<T>(this.prefix, split.body(), newSuffix, upper);
        }
        Object[] newSuffix = new Object[j];
        System.arraycopy(this.suffix, 0, newSuffix, 0, j);
        return new FingerTrieSeq<T>(this.prefix, oldBranch, newSuffix, upper);
    }

    public FingerTrieSeq<T> slice(int lower, int upper) {
        if (lower >= upper) {
            return EMPTY;
        }
        return this.drop(lower).take(upper - Math.max(0, lower));
    }

    public FingerTrieSeq<T> appended(T elem) {
        int i = this.prefix.length;
        int j = this.suffix.length;
        int n = this.branch.length;
        if (n == 0 && j == 0 && i < 32) {
            Object[] newPrefix = new Object[i + 1];
            System.arraycopy(this.prefix, 0, newPrefix, 0, i);
            newPrefix[i] = elem;
            return new FingerTrieSeq<T>(newPrefix, EMPTY_NODE, EMPTY_LEAF, this.length + 1);
        }
        if (n == 0 && i + j < 32) {
            Object[] newPrefix = new Object[i + j + 1];
            System.arraycopy(this.prefix, 0, newPrefix, 0, i);
            System.arraycopy(this.suffix, 0, newPrefix, i, j);
            newPrefix[i + j] = elem;
            return new FingerTrieSeq<T>(newPrefix, EMPTY_NODE, EMPTY_LEAF, this.length + 1);
        }
        if (n == 0 && i + j < 64) {
            Object[] newPrefix = new Object[32];
            System.arraycopy(this.prefix, 0, newPrefix, 0, i);
            System.arraycopy(this.suffix, 0, newPrefix, i, 32 - i);
            Object[] newSuffix = new Object[i + j - 32 + 1];
            System.arraycopy(this.suffix, 32 - i, newSuffix, 0, i + j - 32);
            newSuffix[i + j - 32] = elem;
            return new FingerTrieSeq<T>(newPrefix, EMPTY_NODE, newSuffix, this.length + 1);
        }
        if (j < 32) {
            Object[] newSuffix = new Object[j + 1];
            System.arraycopy(this.suffix, 0, newSuffix, 0, j);
            newSuffix[j] = elem;
            return new FingerTrieSeq<T>(this.prefix, this.branch, newSuffix, this.length + 1);
        }
        Object[] newSuffix = new Object[]{elem};
        FingerTrieSeq<Object[]> newBranch = this.branch.appended(this.suffix);
        return new FingerTrieSeq<T>(this.prefix, newBranch, newSuffix, this.length + 1);
    }

    public FingerTrieSeq<T> appended(Collection<? extends T> elems) {
        FingerTrieSeqBuilder<? extends T> builder = new FingerTrieSeqBuilder<T>(this);
        builder.addAll(elems);
        return builder.bind();
    }

    public FingerTrieSeq<T> prepended(T elem) {
        int i = this.prefix.length;
        int j = this.suffix.length;
        int n = this.branch.length;
        if (n == 0 && j == 0 && i < 32) {
            Object[] newPrefix = new Object[1 + i];
            newPrefix[0] = elem;
            System.arraycopy(this.prefix, 0, newPrefix, 1, i);
            return new FingerTrieSeq<T>(newPrefix, EMPTY_NODE, EMPTY_LEAF, 1 + this.length);
        }
        if (n == 0 && i + j < 32) {
            Object[] newPrefix = new Object[1 + i + j];
            newPrefix[0] = elem;
            System.arraycopy(this.prefix, 0, newPrefix, 1, i);
            System.arraycopy(this.suffix, 0, newPrefix, 1 + i, j);
            return new FingerTrieSeq<T>(newPrefix, EMPTY_NODE, EMPTY_LEAF, 1 + this.length);
        }
        if (n == 0 && i + j < 64) {
            Object[] newPrefix = new Object[1 + i + j - 32];
            newPrefix[0] = elem;
            System.arraycopy(this.prefix, 0, newPrefix, 1, i + j - 32);
            Object[] newSuffix = new Object[32];
            System.arraycopy(this.prefix, i + j - 32, newSuffix, 0, 32 - j);
            System.arraycopy(this.suffix, 0, newSuffix, 32 - j, j);
            return new FingerTrieSeq<T>(newPrefix, EMPTY_NODE, newSuffix, 1 + this.length);
        }
        if (i < 32) {
            Object[] newPrefix = new Object[1 + i];
            newPrefix[0] = elem;
            System.arraycopy(this.prefix, 0, newPrefix, 1, i);
            return new FingerTrieSeq<T>(newPrefix, this.branch, this.suffix, 1 + this.length);
        }
        Object[] newPrefix = new Object[]{elem};
        FingerTrieSeq<Object[]> newBranch = this.branch.prepended(this.prefix);
        return new FingerTrieSeq<T>(newPrefix, newBranch, this.suffix, 1 + this.length);
    }

    public FingerTrieSeq<T> prepended(Collection<? extends T> elems) {
        FingerTrieSeqBuilder<? extends T> builder = new FingerTrieSeqBuilder<T>();
        builder.addAll(elems);
        builder.addAll(this);
        return builder.bind();
    }

    public FingerTrieSeq<T> removed(int index) {
        if (index < 0 || index >= this.length) {
            throw new IndexOutOfBoundsException(Integer.toString(index));
        }
        if (index == 0) {
            return this.drop(1);
        }
        int newLength = this.length - 1;
        if (index == newLength) {
            return this.take(index);
        }
        FingerTrieSeqBuilder<T> builder = new FingerTrieSeqBuilder<T>(this.take(index));
        do {
            builder.add(this.get(++index));
        } while (index < newLength);
        return builder.bind();
    }

    public FingerTrieSeq<T> removed(Object elem) {
        int index = this.indexOf(elem);
        if (index >= 0) {
            return this.removed(index);
        }
        return this;
    }

    @Override
    public FingerTrieSeq<T> subList(int fromIndex, int toIndex) {
        if (fromIndex < 0 || toIndex > this.length || fromIndex > toIndex) {
            throw new IndexOutOfBoundsException(fromIndex + ", " + toIndex);
        }
        return this.drop(fromIndex).take(toIndex - fromIndex);
    }

    @Override
    public Object[] toArray() {
        int n = this.length;
        Object[] array = new Object[n];
        for (int i = 0; i < n; ++i) {
            array[i] = this.get(i);
        }
        return array;
    }

    @Override
    public <T> T[] toArray(T[] array) {
        int n = this.length;
        if (array.length < n) {
            array = (Object[])Array.newInstance(array.getClass().getComponentType(), n);
        }
        for (int i = 0; i < n; ++i) {
            array[i] = this.get(i);
        }
        if (array.length > n) {
            array[n] = null;
        }
        return array;
    }

    @Override
    public Iterator<T> iterator() {
        return new FingerTrieSeqIterator(this);
    }

    @Override
    public ListIterator<T> listIterator() {
        return new FingerTrieSeqIterator(this);
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        return new FingerTrieSeqIterator(this, index);
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof FingerTrieSeq) {
            FingerTrieSeq that = (FingerTrieSeq)other;
            if (this.length == that.length) {
                Iterator<T> these = this.iterator();
                Iterator<T> those = that.iterator();
                while (these.hasNext() && those.hasNext()) {
                    T x = these.next();
                    T y = those.next();
                    if (!(x == null ? y != null : !x.equals(y))) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public int hashCode() {
        if (hashSeed == 0) {
            hashSeed = Murmur3.seed(FingerTrieSeq.class);
        }
        int h = hashSeed;
        Iterator<T> these = this.iterator();
        while (these.hasNext()) {
            h = Murmur3.mix((int)h, (int)Murmur3.hash(these.next()));
        }
        return Murmur3.mash((int)h);
    }

    public <U> Output<U> debug(Output<U> output) {
        output = output.write("FingerTrieSeq").write(46);
        Iterator<T> these = this.iterator();
        if (these.hasNext()) {
            output = output.write("of").write(40).debug(these.next());
            while (these.hasNext()) {
                output = output.write(", ").debug(these.next());
            }
        } else {
            output = output.write("empty").write(40);
        }
        output = output.write(41);
        return output;
    }

    public String toString() {
        return Format.debug((Object)this);
    }

    public static <T> FingerTrieSeq<T> empty() {
        return EMPTY;
    }

    public static <T> FingerTrieSeq<T> of(T elem0, T elem1) {
        FingerTrieSeqBuilder<T> builder = new FingerTrieSeqBuilder<T>();
        builder.add(elem0);
        builder.add(elem1);
        return builder.bind();
    }

    public static <T> FingerTrieSeq<T> of(T ... elems) {
        FingerTrieSeqBuilder<T> builder = new FingerTrieSeqBuilder<T>();
        for (T elem : elems) {
            builder.add(elem);
        }
        return builder.bind();
    }

    public static <T> FingerTrieSeq<T> from(Iterable<? extends T> elems) {
        FingerTrieSeqBuilder<T> builder = new FingerTrieSeqBuilder<T>();
        for (T elem : elems) {
            builder.add(elem);
        }
        return builder.bind();
    }

    public static <T> Builder<T, FingerTrieSeq<T>> builder(FingerTrieSeq<? extends T> trie) {
        return new FingerTrieSeqBuilder<T>(trie);
    }

    public static <T> Builder<T, FingerTrieSeq<T>> builder() {
        return new FingerTrieSeqBuilder();
    }

    static {
        EMPTY_LEAF = new Object[0];
        EMPTY = new FingerTrieSeq();
        EMPTY_NODE = EMPTY;
    }
}

