/*
 * Decompiled with CFR 0.152.
 */
package swim.collections;

import java.util.Collection;
import swim.collections.FingerTrieSeq;
import swim.util.Builder;

final class FingerTrieSeqBuilder<T>
implements Builder<T, FingerTrieSeq<T>> {
    Object[] prefix;
    FingerTrieSeqBuilder<Object[]> branch;
    Object[] buffer;
    int length;

    FingerTrieSeqBuilder(FingerTrieSeq<? extends T> trie) {
        if (trie.length > 32) {
            this.prefix = trie.prefix;
            if (trie.branch.length > 0) {
                this.branch = new FingerTrieSeqBuilder<Object[]>(trie.branch);
            }
            this.buffer = trie.suffix;
        } else if (trie.length > 0) {
            this.buffer = trie.prefix;
        }
        this.length = trie.length;
    }

    FingerTrieSeqBuilder() {
        this.prefix = null;
        this.branch = null;
        this.buffer = null;
        this.length = 0;
    }

    private int getSkew() {
        return (this.prefix != null ? this.length - this.prefix.length : this.length) & 0x1F;
    }

    public boolean add(T elem) {
        int offset = this.getSkew();
        if (offset == 0) {
            if (this.buffer != null) {
                if (this.prefix == null) {
                    this.prefix = this.buffer;
                } else {
                    if (this.branch == null) {
                        this.branch = new FingerTrieSeqBuilder<T>();
                    }
                    this.branch.add(this.buffer);
                }
            }
            this.buffer = new Object[32];
        } else if (this.buffer.length < 32) {
            Object[] newBuffer = new Object[32];
            System.arraycopy(this.buffer, 0, newBuffer, 0, offset);
            this.buffer = newBuffer;
        }
        this.buffer[offset] = elem;
        ++this.length;
        return true;
    }

    public boolean addAll(Collection<? extends T> elems) {
        if (elems instanceof FingerTrieSeq) {
            return this.addAll((FingerTrieSeq)elems);
        }
        for (T elem : elems) {
            this.add(elem);
        }
        return true;
    }

    boolean addAll(FingerTrieSeq<? extends T> that) {
        if (this.length == 0 && that.length != 0) {
            if (that.length > 32) {
                this.prefix = that.prefix;
                if (that.branch.length > 0) {
                    this.branch = new FingerTrieSeqBuilder<Object[]>(that.branch);
                }
                this.buffer = that.suffix;
            } else {
                this.buffer = that.prefix;
            }
            this.length = that.length;
        } else if (that.length != 0) {
            int offset = this.getSkew();
            if ((offset + that.prefix.length & 0x1F) == 0) {
                if (this.buffer.length < 32) {
                    Object[] newBuffer = new Object[32];
                    System.arraycopy(this.buffer, 0, newBuffer, 0, offset);
                    this.buffer = newBuffer;
                }
                if (offset > 0) {
                    System.arraycopy(that.prefix, 0, this.buffer, offset, 32 - offset);
                } else {
                    if (this.prefix == null) {
                        this.prefix = this.buffer;
                    } else {
                        if (this.branch == null) {
                            this.branch = new FingerTrieSeqBuilder<T>();
                        }
                        this.branch.add(this.buffer);
                    }
                    this.buffer = that.prefix;
                }
                if (that.suffix.length > 0) {
                    if (this.branch == null) {
                        this.branch = new FingerTrieSeqBuilder<T>();
                    }
                    this.branch.add(this.buffer);
                    this.branch.addAll(that.branch);
                    this.buffer = that.suffix;
                }
                this.length += that.length;
            } else {
                for (T elem : that) {
                    this.add(elem);
                }
            }
        }
        return true;
    }

    public void clear() {
        this.prefix = null;
        this.branch = null;
        this.buffer = null;
        this.length = 0;
    }

    public FingerTrieSeq<T> bind() {
        if (this.length == 0) {
            return FingerTrieSeq.EMPTY;
        }
        int offset = this.getSkew();
        if (offset != 0 && offset != this.buffer.length) {
            Object[] suffix = new Object[offset];
            System.arraycopy(this.buffer, 0, suffix, 0, offset);
            this.buffer = suffix;
        }
        if (this.prefix == null) {
            return new FingerTrieSeq(this.buffer, FingerTrieSeq.EMPTY_NODE, FingerTrieSeq.EMPTY_LEAF, this.length);
        }
        if (this.branch == null) {
            return new FingerTrieSeq(this.prefix, FingerTrieSeq.EMPTY_NODE, this.buffer, this.length);
        }
        return new FingerTrieSeq(this.prefix, (FingerTrieSeq<Object[]>)this.branch.bind(), this.buffer, this.length);
    }
}

